package com.bcxin.flink.streaming.cores;

import com.bcxin.event.core.JobParameterDTO;
import com.bcxin.event.core.exceptions.NoFoundEventException;

import java.io.IOException;

public abstract class AppAbstract {
    private static final String DATABASE_PROPERTY_CONF="databasePropertyConf";
    protected static void initEnv(String[] args) throws IOException {
        String env = args[0];
        SystemPropertyUtil.loadEnvConf(env);
    }

    protected static JobParameterDTO getJobParameter(String jobId) {
        JobParameterDTO jobParameterDTO = JdbcJobExecutorUtil.getJobParameter(Integer.parseInt(jobId));
        if (jobParameterDTO == null) {
            throw new NoFoundEventException(String.format("找不到该配置项:%s", jobId));
        }

        return jobParameterDTO;
    }

    protected static String getDatabasePropertyConfAfterInitEnv() {
        return System.getProperty(DATABASE_PROPERTY_CONF);
    }
}
