/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.flink.sql.udtfs;

import com.alibaba.fastjson.JSONObject;
import com.bcxin.flink.sql.utils.JsonObjectUtil;
import java.sql.Timestamp;
import java.time.Instant;
import org.apache.commons.lang3.time.StopWatch;
import org.apache.flink.table.annotation.DataTypeHint;
import org.apache.flink.table.annotation.FunctionHint;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.catalog.DataTypeFactory;
import org.apache.flink.table.functions.TableFunction;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.ArgumentTypeStrategy;
import org.apache.flink.table.types.inference.InputTypeStrategies;
import org.apache.flink.table.types.inference.TypeInference;
import org.apache.flink.table.types.inference.TypeStrategies;
import org.apache.flink.types.Row;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FunctionHint(output=@DataTypeHint(value="ROW<id STRING, op STRING,author STRING,lastModifier STRING,database STRING,table STRING,orgId STRING,content STRING>"))
public class DebeziumParserDiffFunction
extends TableFunction<Row> {
    private static final Logger logger = LoggerFactory.getLogger(DebeziumParserDiffFunction.class);

    public void eval(@DataTypeHint(value="STRING") String debeziumJson) {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        StringBuilder sb = new StringBuilder();
        try {
            sb.append(String.format("\u51c6\u5907\u89e3\u6790\u6570\u636e:%s;", Timestamp.from(Instant.now())));
            JSONObject jsonObject = JSONObject.parseObject((String)debeziumJson);
            String op = jsonObject.getString("op");
            JSONObject before = jsonObject.getJSONObject("before");
            JSONObject after = jsonObject.getJSONObject("after");
            JSONObject source = jsonObject.getJSONObject("source");
            JSONObject instance = after == null ? before : after;
            stopWatch.stop();
            sb.append(String.format("\u5e8f\u5217\u5316\u8017\u8d39\u65f6\u95f4=%s\u6beb\u79d2;", stopWatch.getStopTime() - stopWatch.getStartTime()));
            stopWatch.reset();
            stopWatch.start();
            String content = JSONObject.toJSONString(JsonObjectUtil.getDiff(op, before, after));
            stopWatch.stop();
            sb.append(String.format("\u83b7\u53d6\u5dee\u5f02\u5316\u6570\u636e=%s\u6beb\u79d2;", stopWatch.getStopTime() - stopWatch.getStartTime()));
            stopWatch.reset();
            stopWatch.start();
            this.collect(Row.of((Object[])new Object[]{JsonObjectUtil.getId(instance), op, JsonObjectUtil.getAuthor(instance), JsonObjectUtil.getLastModifier(instance), JsonObjectUtil.getOrgId(instance), source.getString("db"), source.getString("table"), content}));
            stopWatch.stop();
            sb.append(String.format("\u83b7\u53d6\u6240\u9700\u8981\u7684\u6570\u636e=%s\u6beb\u79d2;", stopWatch.getStopTime() - stopWatch.getStartTime()));
        }
        catch (Exception ex) {
            logger.error("\u89e3\u6790Debezium\u6570\u636e({})\u53d1\u751f\u5f02\u5e38", (Object)debeziumJson, (Object)ex);
            throw ex;
        }
        finally {
            logger.error("\u89e3\u6790\u6570\u636e\u8ddf\u8e2a:{}", (Object)sb);
        }
    }

    public TypeInference getTypeInference(DataTypeFactory typeFactory) {
        return TypeInference.newBuilder().inputTypeStrategy(InputTypeStrategies.sequence((ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.explicit((DataType)DataTypes.STRING())})).outputTypeStrategy(TypeStrategies.explicit((DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"id", (DataType)DataTypes.STRING()), DataTypes.FIELD((String)"op", (DataType)DataTypes.STRING()), DataTypes.FIELD((String)"author", (DataType)DataTypes.STRING()), DataTypes.FIELD((String)"lastModifier", (DataType)DataTypes.STRING()), DataTypes.FIELD((String)"database", (DataType)DataTypes.STRING()), DataTypes.FIELD((String)"table", (DataType)DataTypes.STRING()), DataTypes.FIELD((String)"orgId", (DataType)DataTypes.STRING()), DataTypes.FIELD((String)"content", (DataType)DataTypes.STRING())}))).build();
    }
}

