/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.flink.sql.udfs;

import com.alibaba.fastjson.JSONObject;
import com.bcxin.flink.sql.utils.JsonObjectUtil;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.table.annotation.DataTypeHint;
import org.apache.flink.table.annotation.FunctionHint;
import org.apache.flink.table.functions.ScalarFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FunctionHint(output=@DataTypeHint(value="STRING"))
public class DebeziumDiffWithMetadataFunction
extends ScalarFunction {
    private static final Logger logger = LoggerFactory.getLogger(DebeziumDiffWithMetadataFunction.class);

    @DataTypeHint(value="STRING")
    public String eval(@DataTypeHint(value="STRING") String evalType, @DataTypeHint(value="STRING") String op, @DataTypeHint(value="STRING") String before, @DataTypeHint(value="STRING") String after) {
        if (StringUtils.isBlank((CharSequence)op)) {
            throw new RuntimeException("\u975e\u9884\u671f\u6570\u636e(op\u4e0d\u80fd\u4e3a\u7a7a)");
        }
        op = op.toLowerCase();
        switch (evalType) {
            case "diff": {
                try {
                    JSONObject beforeObj = null;
                    JSONObject afterObj = null;
                    if ("u".equalsIgnoreCase(op)) {
                        beforeObj = before != null ? JSONObject.parseObject((String)before) : null;
                        afterObj = after != null ? JSONObject.parseObject((String)after) : null;
                    }
                    return JSONObject.toJSONString(JsonObjectUtil.getDiff(op, beforeObj, afterObj));
                }
                catch (Exception e) {
                    logger.error("\u89e3\u6790\u6570\u636e\u53d1\u751f\u5f02\u5e38:{}:before={}; after={}", new Object[]{op, before, after, e});
                    break;
                }
            }
            default: {
                JSONObject instance = null;
                switch (op) {
                    case "c": 
                    case "u": {
                        instance = JSONObject.parseObject((String)after);
                        break;
                    }
                    case "d": {
                        instance = JSONObject.parseObject((String)before);
                    }
                }
                if (instance == null) {
                    return null;
                }
                switch (evalType) {
                    case "getAuthor": {
                        String author = instance.getString("LASTMODIFIER");
                        if (StringUtils.isBlank((CharSequence)author)) {
                            author = instance.getString("AUTHOR");
                        }
                        if (StringUtils.isBlank((CharSequence)author)) {
                            author = instance.getString("leave_operator_id");
                        }
                        if (StringUtils.isBlank((CharSequence)author)) {
                            author = instance.getString("hired_operator_id");
                        }
                        return author;
                    }
                    case "getId": {
                        Optional<String> idOptional = instance.keySet().stream().filter(ii -> ii.equalsIgnoreCase("id") || ii.equalsIgnoreCase("pkId")).findFirst();
                        if (!idOptional.isPresent()) {
                            return null;
                        }
                        String id = instance.getString(idOptional.get());
                        return id;
                    }
                    case "getOrgId": {
                        String domainId = instance.getString("DOMAINID");
                        if (StringUtils.isBlank((CharSequence)domainId)) {
                            domainId = instance.getString("ORGANIZATION_ID");
                        }
                        return domainId;
                    }
                }
                return instance.getString(evalType);
            }
        }
        return "nil";
    }
}

