/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.data.etc.table.tasks.webhookConfigs;

import com.bcxin.tenant.data.etc.table.tasks.utils.WebHookConfigUtil;
import com.bcxin.tenant.data.etc.table.tasks.webhookConfigs.SourceTypeDefinitionGenerator;
import com.bcxin.tenant.data.etc.table.tasks.webhookConfigs.WebHookConfigDefinition;
import com.bcxin.tenant.data.etc.table.tasks.webhookConfigs.WebHookConfigSourceDefinition;
import com.bcxin.tenant.data.etc.table.tasks.webhookConfigs.WebHookConfigSourceMetaDefinition;

public enum WebHookConfigSourceType implements SourceTypeDefinitionGenerator
{
    Kafka{

        @Override
        public String generateSql(WebHookConfigDefinition definition, WebHookConfigSourceDefinition sourceDefinition, WebHookConfigSourceMetaDefinition metaDefinition) {
            String baseTable = WebHookConfigUtil.generateTableDefinition(definition, sourceDefinition, metaDefinition);
            StringBuilder sb = new StringBuilder(baseTable);
            sb.append(") WITH ('connector'='kafka','value.format' = 'debezium-json','scan.startup.mode' = 'group-offsets','properties.enable.auto.commit' = 'true',");
            sb.append("'topic'='" + metaDefinition.getRefSourceTableName() + "',");
            sb.append(String.format("'properties.group.id'='%s','properties.client.id'='1','properties.auto.offset.reset' = 'earliest','properties.bootstrap.servers' = '%s');", definition.getGroupId(), sourceDefinition.getConf()));
            return sb.toString();
        }
    }
    ,
    HttpSink{

        @Override
        public String generateSql(WebHookConfigDefinition definition, WebHookConfigSourceDefinition sourceDefinition, WebHookConfigSourceMetaDefinition metaDefinition) {
            String baseTable = WebHookConfigUtil.generateTableDefinition(definition, sourceDefinition, metaDefinition);
            StringBuilder sb = new StringBuilder(baseTable);
            sb.append(") WITH ('connector'='http-sink','url' = '" + metaDefinition.getRefSourceTableName() + "','format' = 'json','insert-method'='POST','sink.flush-buffer.timeout'='10000','gid.connector.http.security.cert.server.allowSelfSigned'='true','gid.connector.http.sink.writer.request.mode'='batch','gid.connector.http.sink.request.batch.size'='50', 'gid.connector.http.sink.header.Content-Type'='application/json','gid.connector.http.sink.header.accessToken'='eyJhbGciOiJIUzI1NiJ9.eyJpc3MiOiJhdXRoMCIsImV4cCI6MTY5MjI1NjE3OSwidXNlcm5hbWUiOiJfX0E3eVZ2ajMzUlJIc09MZ3Z0MGQifQ.lYdiapzXehI7rPuQg8qBH2_cYLkiCarQvWmoiCaL0PU');");
            return sb.toString();
        }
    };

}

