/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.data.etc.table.tasks.components.httpsink;

import com.bcxin.tenant.data.etc.table.tasks.components.httpsink.HttpExecutionOptions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.io.OutputFormat;
import org.apache.flink.api.common.io.RichOutputFormat;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.concurrent.ExecutorThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

@Internal
public class HttpOutputStringFormat
extends RichOutputFormat<String> {
    private static final Logger logger = LoggerFactory.getLogger(HttpOutputStringFormat.class);
    private final HttpExecutionOptions executionOptions;
    private transient ScheduledExecutorService scheduler;
    private transient ScheduledFuture<?> scheduledFuture;
    private volatile transient boolean closed = false;
    private volatile transient Exception flushException;
    private final Collection<String> records = new ArrayList<String>();

    public HttpOutputStringFormat(HttpExecutionOptions executionOptions) {
        this.executionOptions = (HttpExecutionOptions)Preconditions.checkNotNull((Object)executionOptions);
    }

    public void open(OutputFormat.InitializationContext context) throws IOException {
        super.open(context);
        this.scheduler = Executors.newScheduledThreadPool(1, (ThreadFactory)new ExecutorThreadFactory("jdbc-upsert-output-format"));
        this.scheduledFuture = this.scheduler.scheduleWithFixedDelay(() -> {
            HttpOutputStringFormat httpOutputStringFormat = this;
            synchronized (httpOutputStringFormat) {
                if (!this.closed) {
                    try {
                        this.flush();
                    }
                    catch (Exception e) {
                        this.flushException = e;
                    }
                }
            }
        }, this.executionOptions.getBatchIntervalMs(), this.executionOptions.getBatchIntervalMs(), TimeUnit.MILLISECONDS);
    }

    public void configure(Configuration parameters) {
    }

    public synchronized void writeRecord(String record) throws IOException {
        this.checkFlushException();
        this.records.add(record);
        if (record.length() >= this.executionOptions.getBatchSize()) {
            this.flush();
        }
    }

    public void close() throws IOException {
        if (this.closed) {
            this.closed = true;
        }
        if (this.scheduledFuture != null) {
            this.scheduledFuture.cancel(false);
            this.scheduler.shutdown();
        }
        if (CollectionUtils.isEmpty(this.records)) {
            try {
                this.flush();
            }
            catch (Exception e) {
                logger.warn("Writing records to JDBC failed.", (Throwable)e);
                throw new RuntimeException("Writing records to JDBC failed.", e);
            }
        }
    }

    private void checkFlushException() {
        if (this.flushException != null) {
            throw new RuntimeException("Writing records to JDBC failed.", this.flushException);
        }
    }

    private void flush() {
        this.records.clear();
    }
}

