package com.bcxin.tenant.data.etc.table.tasks.webhookConfigs;

import lombok.Data;
import org.apache.flink.types.Row;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Data
public class WebHookConfigSourceMetaDefinition  extends DefinitionAbstract {
    private String refSourceName;
    private String refSourceTableName;
    private String tableName;
    private boolean isSource;
    private Collection<WebHookConfigSourceMetaColumnDefinition> columns;

    public String getInsertSql(Row row) {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("INSERT INTO %s", this.getTableName()));

        sb.append("(");
        StringBuilder value = new StringBuilder();
        value.append("(");
        List<WebHookConfigSourceMetaColumnDefinition> columnDefinitions =
                this.getColumns().stream().filter(ii->!ii.isConstraintDefinition()).collect(Collectors.toList());

        for (int index = 0; index < columnDefinitions.size(); index++) {
            WebHookConfigSourceMetaColumnDefinition columnDefinition = columnDefinitions.get(index);

            String columnName = columnDefinition.getName();
            sb.append(columnName);
            value.append(String.format("'%s'", row.getField(columnName)));

            if (index < columnDefinitions.size() - 1) {
                sb.append(",");
                value.append(",");
            }
        }

        value.append(")");
        sb.append(")VALUES");

        sb.append(value);


        return sb.toString();
    }

    public boolean IsHttpConfig(Collection<WebHookConfigSourceDefinition> sourceDefinitions)
    {
        if(CollectionUtils.isEmpty(sourceDefinitions) || !StringUtils.hasLength(this.getRefSourceName())) {
            return false;
        }

        return sourceDefinitions.stream().anyMatch(ii->ii.getName().equalsIgnoreCase(this.getRefSourceName()) && ii.getType()==WebHookConfigSourceType.HttpSink);
    }

    public String getSql() {
        return "";
    }

    @Data
    public static class WebHookConfigSourceMetaColumnDefinition extends DefinitionAbstract {
        private String name;
        private String type;
        private boolean constraintDefinition;
    }
}
