package com.bcxin.tenant.data.etc.table.tasks.webhookConfigs;

import lombok.Data;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;

@Data
public class WebHookConfigSourceDefinition extends DefinitionAbstract {
    public static final String REQUEST_HEADER_PREFIX="gid.connector.http.sink.header.";

    public static final String REQUEST_HEADER_AUTHORIZATION="gid.connector.http.sink.header.Authorization";
    public static final String REQUEST_HEADER_ACCESS_TOKEN="gid.connector.http.sink.header.accessToken";
    public static final String REQUEST_HEADER_ACCESS_TOKEN_ORIGINAL="accessToken";
    public static final String CURRENT_REQUEST_USER_ID="gid.connector.http.sink.user.id";

    public static final String INSERT_METHOD="POST";

    private String name;
    private WebHookConfigSourceType type;
    private String conf;
    private Map<String, String> extendMap;

    public String getMapValue(String key) {
        if (CollectionUtils.isEmpty(this.getExtendMap())) {
            return null;
        }

        return this.getExtendMap().get(key);
    }

    public Collection<String> getHeadValues() {
        if (CollectionUtils.isEmpty(this.getExtendMap())) {
            return Collections.EMPTY_LIST;
        }

        return this.getExtendMap().entrySet().stream()
                .filter(ii -> ii.getKey().startsWith(REQUEST_HEADER_PREFIX))
                .map(ii -> ii.getValue())
                .collect(Collectors.toList());
    }
}
