package com.bcxin.tenant.data.etc.table.tasks.webhookConfigs;

import com.bcxin.event.core.exceptions.BadEventException;
import com.bcxin.event.core.exceptions.NoFoundEventException;
import lombok.Data;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.stream.Collectors;

@Data
public class WebHookConfigDefinition extends DefinitionAbstract {
    private String name;
    private String groupId;
    private Collection<WebHookConfigSourceDefinition> sources;
    private Collection<WebHookConfigSourceMetaDefinition> metaDefinitions;
    private WebHookConfigExecuteDefinition executeDefinition;

    public Collection<String> getHookConfigSourceSql() {
        if (CollectionUtils.isEmpty(this.getSources())) {
            return Collections.EMPTY_LIST;
        }

        Collection<String> batchSql =
                this.getMetaDefinitions().stream().map(meta -> {
                    Optional<WebHookConfigSourceDefinition> selectedSourceOptional
                            = this.getSources().stream().filter(sr -> sr.getName().equalsIgnoreCase(meta.getRefSourceName()))
                            .findFirst();

                    if (!selectedSourceOptional.isPresent()) {
                        throw new NoFoundEventException("无效的Source信息");
                    }

                    /**
                     * 先过滤掉HttpSink的定义
                     */
                    if (selectedSourceOptional.get().getType() == WebHookConfigSourceType.HttpSink) {
                        return null;
                    }

                    WebHookConfigSourceDefinition selectedSource = selectedSourceOptional.get();

                    return selectedSource.getType().generateSql(this, selectedSource, meta);
                }).filter(ii -> StringUtils.hasLength(ii)).collect(Collectors.toList());

        return batchSql;
    }
}
