package com.bcxin.tenant.data.etc.table.tasks.utils;

import com.bcxin.tenant.data.etc.table.tasks.webhookConfigs.WebHookConfigDefinition;
import com.bcxin.tenant.data.etc.table.tasks.webhookConfigs.WebHookConfigSourceDefinition;
import com.bcxin.tenant.data.etc.table.tasks.webhookConfigs.WebHookConfigSourceMetaDefinition;

import java.util.List;
import java.util.stream.Collectors;

public class WebHookConfigUtil {
    public static String generateTableDefinition(WebHookConfigDefinition definition,
                                                 WebHookConfigSourceDefinition sourceDefinition,
                                                 WebHookConfigSourceMetaDefinition metaDefinition)
    {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("create table %s(", metaDefinition.getTableName()));
        List<WebHookConfigSourceMetaDefinition.WebHookConfigSourceMetaColumnDefinition> columnDefinitions =
                metaDefinition.getColumns().stream().collect(Collectors.toList());

        for (int index = 0; index < columnDefinitions.size(); index++) {
            WebHookConfigSourceMetaDefinition.WebHookConfigSourceMetaColumnDefinition selectedColumn = columnDefinitions.get(index);
            if (selectedColumn.isConstraintDefinition()) {
                sb.append(selectedColumn.getName());
            } else {
                sb.append(String.format("%s %s", selectedColumn.getName(), selectedColumn.getType()));
                if (index < columnDefinitions.size() - 1) {
                    sb.append(",");
                }
            }
        }

        return sb.toString();
    }
}
