package com.bcxin.tenant.data.etc.table.tasks.utils;

import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class SqlDefinitionUtils {
    public static Collection<String> getSqlDefinitions() {
        Collection<String> sql =
                Arrays.stream(("CREATE TABLE source_kafka_tenant_employees(\n" +
                        "id STRING,created_time BIGINT,tenant_user_id STRING,occupation_type SMALLINT,status SMALLINT,\n" +
                        "organization_id STRING,department_id STRING,hired_date BIGINT,leave_time BIGINT,\n" +
                        "PRIMARY KEY (id) NOT ENFORCED\n" +
                        ")\n" +
                        "WITH ('connector'='kafka','scan.startup.mode'='group-offsets',\n" +
                        "      'properties.group.id'='flink-sql-consumer-jdbc-v3',\n" +
                        "      'topic' = 'obpm2.binlog-cdc.topic.v2.tenant_employees-test',\n" +
                        "      'properties.bootstrap.servers' = '117.78.39.204:9092','properties.auto.offset.reset' = 'earliest',\n" +
                        "      'properties.enable.auto.commit' = 'true','format'='debezium-json');\n" +
                        "CREATE TABLE source_kafka_tenant_users(\n" +
                        "id STRING,created_time BIGINT,name STRING,telephone STRING,\n" +
                        "selected_credential_id STRING,one_inch_color_white_photo STRING,checked_status SMALLINT,authenticated_status SMALLINT,\n" +
                        "PRIMARY KEY (id) NOT ENFORCED\n" +
                        ")\n" +
                        "WITH ('connector'='kafka','scan.startup.mode'='group-offsets',\n" +
                        "      'properties.group.id'='flink-sql-consumer-jdbc-v3',\n" +
                        "      'topic' = 'obpm2.binlog-cdc.topic.v2.tenant_users-test',\n" +
                        "      'properties.bootstrap.servers' = '117.78.39.204:9092','properties.auto.offset.reset' = 'earliest',\n" +
                        "      'properties.enable.auto.commit' = 'true','format'='debezium-json');\n" +
                        "CREATE TABLE source_kafka_tenant_user_credentials(\n" +
                        "id STRING,created_time BIGINT,credential_type SMALLINT,front_photo STRING,\n" +
                        "head_photo STRING,name STRING,number STRING,tenant_user_id STRING,\n" +
                        "PRIMARY KEY (id) NOT ENFORCED\n" +
                        ")\n" +
                        "WITH ('connector'='kafka','scan.startup.mode'='group-offsets',\n" +
                        "      'properties.group.id'='flink-sql-consumer-jdbc-v3',\n" +
                        "      'topic' = 'obpm2.binlog-cdc.topic.v2.tenant_user_credentials-test',\n" +
                        "      'properties.bootstrap.servers' = '117.78.39.204:9092','properties.auto.offset.reset' = 'earliest',\n" +
                        "      'properties.enable.auto.commit' = 'true','format'='debezium-json');\n" +
                        "\n" +
                        "CREATE TABLE source_kafka_tenant_organizations(\n" +
                        "id STRING,created_time BIGINT,name STRING,place_of_business_address STRING,\n" +
                        "PRIMARY KEY (id) NOT ENFORCED\n" +
                        ")\n" +
                        "WITH ('connector'='kafka','scan.startup.mode'='group-offsets',\n" +
                        "      'properties.group.id'='flink-sql-consumer-jdbc-v3',\n" +
                        "      'topic' = 'obpm2.binlog-cdc.topic.v2.tenant_organizations-test',\n" +
                        "      'properties.bootstrap.servers' = '117.78.39.204:9092','properties.auto.offset.reset' = 'earliest',\n" +
                        "      'properties.enable.auto.commit' = 'true','format'='debezium-json');\n" +
                        "CREATE TABLE source_kafka_tlk_attendance_site_base_info\n" +
                        "(\n" +
                        "   ID STRING,created_time BIGINT,ITEM_attendanceSiteName STRING,ITEM_attendanceStartDate BIGINT,ITEM_attendanceEndDate BIGINT,\n" +
                        "   ITEM_attendanceSiteState STRING,DOMAINID STRING,ITEM_officePoliceAddressID STRING,ITEM_officePoliceAddress STRING,\n" +
                        "   PRIMARY KEY (ID) NOT ENFORCED\n" +
                        ") WITH ('connector'='kafka','scan.startup.mode'='group-offsets',\n" +
                        "        'properties.group.id'='flink-sql-consumer-jdbc-v3',\n" +
                        "        'topic' = 'baibaodunflow.binlog-cdc.topic.v2.tlk_attendance_site_base_info-test',\n" +
                        "        'properties.bootstrap.servers' = '117.78.39.204:9092','properties.auto.offset.reset' = 'earliest',\n" +
                        "        'properties.enable.auto.commit' = 'true','format'='debezium-json');\n" +
                        "CREATE TABLE source_kafka_tlk_attendance_site_person_info\n" +
                        "(\n" +
                        "    ID STRING,created_time BIGINT,ITEM_securityId STRING,ITEM_attendanceSiteId STRING,ITEM_documentID STRING,\n" +
                        "    DOMAINID STRING,\n" +
                        "    PRIMARY KEY (ID) NOT ENFORCED\n" +
                        ") WITH ('connector'='kafka','scan.startup.mode'='group-offsets',\n" +
                        "      'properties.group.id'='flink-sql-consumer-jdbc-v3',\n" +
                        "      'topic' = 'baibaodunflow.binlog-cdc.topic.v2.tlk_attendance_site_base_info-test',\n" +
                        "      'properties.bootstrap.servers' = '117.78.39.204:9092','properties.auto.offset.reset' = 'earliest',\n" +
                        "      'properties.enable.auto.commit' = 'true','format'='debezium-json');\n" +
                        "CREATE TABLE sink_flink_tenant_organizations(\n" +
                        "                                        id STRING,\n" +
                        "                                        created_time BIGINT,\n" +
                        "                                        `name` STRING,\n" +
                        "                                        place_of_business_address STRING,\n" +
                        "                                        numOfSecurityMen BIGINT,\n" +
                        "                                        numOfSecurityStation BIGINT,\n" +
                        "                                        PRIMARY KEY (id) NOT ENFORCED\n" +
                        ")\n" +
                        "    with(\n" +
                        "        'connector'='jdbc',\n" +
                        "        'url'='jdbc:mysql://49.4.30.59:16823/obpm2',\n" +
                        "        'driver'='com.mysql.cj.jdbc.Driver',\n" +
                        "        'username'='root',\n" +
                        "        'password'='Dxdf#0519.com',\n" +
                        "        'table-name'='stream_tenant_organizations','sink.parallelism'='1');\n"+
"CREATE TABLE sink_flink_tenant_organizations_join(\n" +
                        "                                                id STRING,\n" +
                        "                                                created_time BIGINT,\n" +
                        "                                                `name` STRING,\n" +
                        "                                                place_of_business_address STRING,\n" +
                        "                                                numOfSecurityMen BIGINT,\n" +
                        "                                                numOfSecurityStation BIGINT,\n" +
                        "                                                PRIMARY KEY (id) NOT ENFORCED\n" +
                        ")\n" +
                        "    with(\n" +
                        "        'connector'='jdbc',\n" +
                        "        'url'='jdbc:mysql://49.4.30.59:16823/obpm2',\n" +
                        "        'driver'='com.mysql.cj.jdbc.Driver',\n" +
                        "        'username'='root',\n" +
                        "        'password'='Dxdf#0519.com',\n" +
                        "        'table-name'='stream_tenant_organizations_join','sink.parallelism'='1'\n" +
                        "        );"
                        ).split("\\;")).collect(Collectors.toList());

        return sql;
    }

    public static Collection<String> getSqlExecute() {
        Collection<String> exeuteSql = Stream.of(
                "insert into sink_flink_tenant_organizations select o.id,o.created_time,o.name,\n" +
                        "       (select k.ITEM_attendanceSiteName from source_kafka_tlk_attendance_site_base_info k\n" +
                        "               where k.DOMAINID=o.id and k.ITEM_attendanceSiteState='生效'\n" +
                        "               order by ITEM_attendanceStartDate desc limit 1) as place_of_business_address,\n" +
                        "       (select count(distinct k.id) from source_kafka_tenant_employees k\n" +
                        "               where k.organization_id=o.id and k.occupation_type=1 and k.status=0) as numOfSecurityMen,\n" +
                        "        (select count(distinct k.ID) from source_kafka_tlk_attendance_site_base_info k\n" +
                        "               where k.DOMAINID=o.id and k.ITEM_attendanceSiteState='生效') as numOfSecurityStation\n" +
                        "from source_kafka_tenant_organizations o",


                "insert into sink_flink_tenant_organizations_join\n" +
                        "select o.id,o.created_time,o.name,\n" +
                        "        max(k.ITEM_attendanceSiteName) as place_of_business_address,\n" +
                        "        count(distinct t.id) as numOfSecurityMen,\n" +
                        "        count(distinct k.ID) as numOfSecurityStation\n" +
                        "from source_kafka_tenant_organizations o\n" +
                        "left join source_kafka_tlk_attendance_site_base_info k on o.id=k.DOMAINID and k.ITEM_attendanceSiteState='生效'\n" +
                        "left join source_kafka_tenant_employees t on t.organization_id=o.id and t.occupation_type=1 and t.status=0\n" +
                        "group by o.id,o.created_time,o.name;"
        ).collect(Collectors.toList());

        return exeuteSql;
    }
}
