package com.bcxin.tenant.data.etc.table.tasks.utils;

import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.exceptions.JWTVerificationException;
import com.auth0.jwt.interfaces.DecodedJWT;

import java.io.UnsupportedEncodingException;
import java.util.Date;

public class JwtUtil {
    private static final String JWT_USER_ID="username";
    private static final String SECRET_KEY = "teemlink_obpm";
    private static JWTVerifier verifier;
    private static final long EXPIRE_TIME = 100 * 10 * 24 * 60 * 60 * 1000;

    static {
        try {
            verifier = JWT.require(Algorithm.HMAC256(SECRET_KEY)).withIssuer("auth0").build();
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    public static String getToken(String userId) {
        String token = null;
        try {
            token = JWT.create()
                    .withIssuer("auth0")
                    .withClaim(JwtUtil.JWT_USER_ID, userId)
                    // 使用了HMAC256加密算法。
                    .sign(Algorithm.HMAC256(SECRET_KEY));
        } catch (Exception e) {
            System.err.println("getToken发生异常:");
            e.printStackTrace();
        }

        return token;
    }
}
