package com.bcxin.tenant.data.etc.table.tasks.utils;

import com.bcxin.event.core.JsonProvider;
import com.bcxin.event.core.JsonProviderImpl;
import com.bcxin.event.core.exceptions.BadEventException;
import com.bcxin.tenant.data.etc.table.tasks.webhookConfigs.WebHookConfigDefinition;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.IOUtils;

import java.io.IOException;
import java.io.InputStream;

public class HookConfigParseUtils {
    public static WebHookConfigDefinition parse(String env, String configFile) {
        StringBuilder sb = new StringBuilder();
        JsonProvider jsonProvider = new JsonProviderImpl();

        ClassLoader classLoader = HookConfigParseUtils.class.getClassLoader();

        sb.append(String.format("正在加载配置文件:%s;", configFile));
        try (InputStream coreStream = classLoader.getResourceAsStream(
                String.format("configs/%s/%s.json", env, configFile))) {
            if (coreStream == null) {
                throw new BadEventException(String.format("v2.找不到该环境配置:%s 及其文件:%s", env, configFile));
            }

            String content = IOUtils.toString(coreStream, Charsets.toCharset("UTF-8"));
            WebHookConfigDefinition configDefinition =
                    jsonProvider.toObject(WebHookConfigDefinition.class, content);

            return configDefinition;
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}
