package com.bcxin.tenant.data.etc.table.tasks.components.httpsink;

import lombok.Getter;
import org.apache.flink.util.Preconditions;

import java.io.Serializable;

@Getter
public class HttpExecutionOptions implements Serializable {
    public static final int DEFAULT_MAX_RETRY_TIMES = 3;
    private static final int DEFAULT_INTERVAL_MILLIS = 0;
    public static final int DEFAULT_SIZE = 5000;

    private final long batchIntervalMs;
    private final int batchSize;
    private final int maxRetries;

    private HttpExecutionOptions(long batchIntervalMs, int batchSize, int maxRetries) {
        Preconditions.checkArgument(maxRetries >= 0);
        this.batchIntervalMs = batchIntervalMs;
        this.batchSize = batchSize;
        this.maxRetries = maxRetries;
    }


    public static HttpExecutionOptions create(long batchIntervalMs, int batchSize, int maxRetries) {
        return new HttpExecutionOptions(batchIntervalMs, batchSize, maxRetries);
    }
}
