package com.bcxin.tenant.data.etc.table.tasks.components.httpsink;

import com.getindata.connectors.http.HttpPostRequestCallback;
import com.getindata.connectors.http.internal.table.sink.Slf4jHttpPostRequestCallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.apache.flink.configuration.ConfigOption;

import java.util.Set;

@Slf4j
public class CustomHttpSinkRequestCallbackFactory extends Slf4jHttpPostRequestCallbackFactory {

    public static final String IDENTIFIER = "custom-http-sink-callback";

    public CustomHttpSinkRequestCallbackFactory() {
        String c = "hello";
        log.error("初始化-{}", c);
    }

    @Override
    public HttpPostRequestCallback createHttpPostRequestCallback() {
        return new CustomHttpPostRequestCallback();
    }

    @Override
    public String factoryIdentifier() {
        return IDENTIFIER;
    }

    @Override
    public Set<ConfigOption<?>> requiredOptions() {
        return super.requiredOptions();
    }

    @Override
    public Set<ConfigOption<?>> optionalOptions() {
        return super.optionalOptions();
    }
}
