package com.bcxin.tenant.data.etc.table.tasks.components.httpsink;
import com.getindata.connectors.http.internal.sink.httpclient.HttpRequest;
import com.getindata.connectors.http.internal.table.sink.Slf4jHttpPostRequestCallback;
import com.getindata.connectors.http.internal.utils.ConfigUtils;
import lombok.extern.slf4j.Slf4j;

import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;

@Slf4j
public class CustomHttpPostRequestCallback extends Slf4jHttpPostRequestCallback {
    @Override
    public void call(HttpResponse<String> response, HttpRequest requestEntry, String endpointUrl, Map<String, String> headerMap) {
        try {
            super.call(response, requestEntry, endpointUrl, headerMap);

            Collection<byte[]> requestElements = requestEntry.getElements();
            String requestBody = requestElements.stream()
                    .map(element -> new String(element, StandardCharsets.UTF_8))
                    .collect(Collectors.joining());

            if (response == null) {
                log.error(
                        "[状态={}]-分发订阅数据至{}; 请求方法= {}\n    请求Body={}\n  Response: null",
                        response.statusCode(),
                        endpointUrl,
                        requestEntry.getMethod(),
                        requestBody
                );
            } else {
                log.error(
                        "[状态={}]-分发订阅数据至{}; 请求方法= {}\n    请求Body= {}\n  响应内容: {}\n    Body: {}",
                        response.statusCode(),
                        endpointUrl,
                        requestEntry.method,
                        requestBody,
                        response,
                        response.body().replaceAll(ConfigUtils.UNIVERSAL_NEW_LINE_REGEXP, "")
                );
            }
        }
        catch (Exception ex) {
            log.error("执行CustomHttpPostRequestCallback(响应={})发生异常:{}", response, response.body(), ex);
        }
    }
}
