package com.bcxin.tenant.data.etc.table.tasks.components;

import org.apache.flink.table.annotation.DataTypeHint;
import org.apache.flink.table.functions.ScalarFunction;
import org.springframework.util.StringUtils;

public class ExtractV5MappingIdFromAccountFunction extends ScalarFunction {
    public @DataTypeHint("VARCHAR") String eval(String... values) {
        if (values.length < 2) {
            return null;
        }

        String input = values[0];
        if (!StringUtils.hasLength(input)) {
            return null;
        }

        String prefix = values[1];
        if (!StringUtils.hasLength(prefix)) {
            return input;
        }

        for (String sub : prefix.split("\\|")) {
            if (input.startsWith(sub)) {
                return input.substring(sub.length());
            }
        }


        return input;
    }
}
