package com.bcxin.tenant.data.etc.table.tasks.components;

import com.bcxin.event.core.JobParameterDTO;
import com.bcxin.event.core.exceptions.BadEventException;
import com.bcxin.flink.streaming.cores.DataSourceUtil;
import org.apache.flink.table.annotation.DataTypeHint;
import org.apache.flink.table.functions.ScalarFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

import javax.sql.DataSource;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Properties;

public class ExtractTableFieldFromDb  extends ScalarFunction {
    private final String driverName;
    private final String dataSourceUrl;
    private final String dataSourceUserName;
    private final String dataSourcePassword;

    private static final Logger logger = LoggerFactory.getLogger(ExtractTableFieldFromDb.class);

    public ExtractTableFieldFromDb(Properties properties) {
        this.driverName = properties.getProperty(JobParameterDTO.JDBC_DATASOURCE_DRIVER_NAME);
        this.dataSourceUrl = properties.getProperty(JobParameterDTO.JDBC_DATASOURCE_URL);
        this.dataSourceUserName = properties.getProperty(JobParameterDTO.JDBC_DATASOURCE_USERNAME);
        this.dataSourcePassword = properties.getProperty(JobParameterDTO.JDBC_DATASOURCE_PASSWORD);

        if (!StringUtils.hasLength(dataSourceUrl)) {
            throw new BadEventException(String.format("Jdbc 配置信息无效:%s", dataSourceUrl));
        }
    }

    public @DataTypeHint("VARCHAR") String eval(String... values) {
        if (values.length < 2) {
            throw new BadEventException();
        }


        String tableName = values[0];
        if (!StringUtils.hasLength(tableName)) {
            throw new BadEventException();
        }

        String selectdFieldName = values[1];
        if (!StringUtils.hasLength(selectdFieldName)) {
            throw new BadEventException();
        }

        String fieldName = values[2];
        if (!StringUtils.hasLength(fieldName)) {
            throw new BadEventException();
        }

        String fieldValue = values[3];
        if (!StringUtils.hasLength(fieldValue)) {
            throw new BadEventException();
        }

        DataSource dataSource = DataSourceUtil.getDataSource(driverName, dataSourceUrl, dataSourceUserName, dataSourcePassword);
        String sql = String.format("select %s from %s where %s=%s", selectdFieldName, tableName, fieldName, fieldValue);

        String extractFieldValue = null;
        try {
            try (Connection connection = dataSource.getConnection()) {
                try (PreparedStatement statement = connection.prepareStatement(sql)) {
                    try (ResultSet resultSet = statement.executeQuery()) {
                        if (resultSet.next()) {
                            extractFieldValue = resultSet.getString(selectdFieldName);
                            return extractFieldValue;
                        }
                    }
                }
            }

            return null;
        } catch (Exception ex) {
            throw new BadEventException();
        } finally {
            logger.error("推送数据获取到如下信息:{};Value={}", sql, extractFieldValue);
        }
    }
}
