package com.bcxin.flink.cdc.kafka.source.task.cdcs.interceptors;

import com.bcxin.event.core.exceptions.BadEventException;
import com.bcxin.event.job.core.domain.dtos.RedisConfig;
import com.bcxin.flink.cdc.kafka.source.task.cdcs.RedisOutputFormat;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;

import java.io.IOException;
import java.util.Map;

/**
 * INTERCEPTOR_CLASSES_CONFIG.
 * interceptor.classes"
 */
public class CustomProducerInterceptor implements org.apache.kafka.clients.producer.ProducerInterceptor<byte[],byte[]>{
    private transient RedisOutputFormat redisOutputFormat;
    public static final String REDIS_CONFIG_KEY_HOST="REDIS_CONFIG_KEY_HOST";
    public static final String REDIS_CONFIG_KEY_PORT="REDIS_CONFIG_KEY_PORT";
    public static final String REDIS_CONFIG_KEY_PASSWORD="REDIS_CONFIG_KEY_PASSWORD";

    public CustomProducerInterceptor() {

    }

    @Override
    public ProducerRecord onSend(ProducerRecord<byte[],byte[]> record) {
        /**
         * 执行Redis
         */
        String value = new String(record.value());
        try {
            this.redisOutputFormat.writeRecord(value);
        } catch (IOException e) {
            throw new BadEventException("将数据计算到Redis发生异常", e);
        }

        return record;
    }

    @Override
    public void onAcknowledgement(RecordMetadata metadata, Exception exception) {

    }

    @Override
    public void close() {
        try {
            this.redisOutputFormat.close();
        } catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void configure(Map<String, ?> configs) {
        if (!configs.containsKey(REDIS_CONFIG_KEY_HOST) ||
                !configs.containsKey(REDIS_CONFIG_KEY_PORT) ||
                !configs.containsKey(REDIS_CONFIG_KEY_PASSWORD)) {
            throw new BadEventException(String.format("%s配置不能为空", REDIS_CONFIG_KEY_HOST));
        }

        try {
            int port =Integer.parseInt((String) configs.get(REDIS_CONFIG_KEY_PORT));
            RedisConfig redisConfig = RedisConfig.create(
                    (String) configs.get(REDIS_CONFIG_KEY_HOST),
                    port,
                    30_000,
                    (String) configs.get(REDIS_CONFIG_KEY_PASSWORD)
            );

            this.redisOutputFormat = new RedisOutputFormat(redisConfig);
            this.redisOutputFormat.open(1, 1);
        } catch (Exception ex) {
            throw new BadEventException("初始化Redis");
        }
    }
}
