package com.bcxin.data.event.transfer.web.apis.controllers.responses;

import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;

@Data
public class ResourceResponse implements Serializable {
    private boolean success;
    private String msg;
    private Object data;

    public static ResourceResponse create(Object data) {
        ResourceResponse response = new ResourceResponse();
        response.setData(data);
        response.setSuccess(true);
        response.setMsg("操作成功");

        return response;
    }

    public static ResourceResponse createOk() {
        ResourceResponse response = new ResourceResponse();
        response.setData(null);
        response.setSuccess(true);
        response.setMsg("操作成功");

        return response;
    }

    public static ResourceResponse createError(String msg) {

        return createError(msg, null);
    }

    public static ResourceResponse createError(String msg,Object data) {
        ResourceResponse response = new ResourceResponse();
        response.setData(data);
        response.setSuccess(false);
        response.setMsg(StringUtils.isEmpty(msg) ? "操作失败" : msg);

        return response;
    }
}
