/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.flink.streaming.cores.properties;

import com.bcxin.flink.streaming.cores.properties.CheckpointConfigProperty;
import com.bcxin.flink.streaming.cores.properties.impls.DiskCheckpointConfigPropertyImpl;
import com.bcxin.flink.streaming.cores.properties.impls.HdfsCheckpointConfigPropertyImpl;
import java.io.IOException;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.api.java.utils.ParameterTool;
import org.apache.hadoop.conf.Configuration;

public class CheckpointConfigPropertyBuilder {
    public static CheckpointConfigProperty build(Properties properties, ParameterTool parameterTool) throws IOException {
        String mode;
        CheckpointConfigProperty configProperty = null;
        switch (mode = properties.getProperty("checkpoint.mode")) {
            case "file": {
                configProperty = DiskCheckpointConfigPropertyImpl.create(properties.getProperty("checkpoint.disk.location"), parameterTool);
                break;
            }
            case "hdfs": {
                String coreSiteConfig = properties.getProperty("checkpoint.hdfs.config");
                Configuration.addDefaultResource((String)coreSiteConfig);
                Configuration conf = new Configuration();
                if (!StringUtils.isEmpty((CharSequence)properties.getProperty("fs.defaultFS"))) {
                    conf.set("fs.defaultFS", properties.getProperty("fs.defaultFS"));
                }
                if (!StringUtils.isEmpty((CharSequence)properties.getProperty("hdfs.checkpoint.contextPath"))) {
                    conf.set("hdfs.checkpoint.contextPath", properties.getProperty("hdfs.checkpoint.contextPath"));
                }
                if (!StringUtils.isEmpty((CharSequence)properties.getProperty("ipc.maximum.data.length"))) {
                    conf.set("ipc.maximum.data.length", properties.getProperty("ipc.maximum.data.length"));
                }
                if (!StringUtils.isEmpty((CharSequence)properties.getProperty("ipc.maximum.response.length"))) {
                    conf.set("ipc.maximum.response.length", properties.getProperty("ipc.maximum.response.length"));
                }
                configProperty = HdfsCheckpointConfigPropertyImpl.create(conf, conf.get("fs.defaultFS"), conf.get("hdfs.checkpoint.contextPath"), parameterTool);
            }
        }
        return configProperty;
    }
}

