package com.bcxin.flink.streaming.table.tasks.definitions;

import com.bcxin.event.core.definitions.FlinkDefinitionAbstract;
import lombok.Data;
import java.util.Collection;

@Data
public class JdbcMetaDefinition extends FlinkDefinitionAbstract {
    private String url;
    private String userName;
    private String password;
    private Collection<JdbcMetaSqlDefinition> sqlMetaDefinitions;

    @Data
    public static class JdbcMetaSqlDefinition extends FlinkDefinitionAbstract {
        private String tableName;
        private String sql;

        public String getFullSql(JdbcMetaDefinition definition) {
            String withJdbcPropertyFormat =
                    " WITH ('connector'='jdbc','url'='%s'," +
                            "'table-name'='%s','username'='%s','password'='%s','sink.parallelism'='1')";
            return this.getSql().concat(String.format(withJdbcPropertyFormat, definition.getUrl(),
                    this.getTableName(), definition.getUserName(), definition.getPassword()));
        }
    }
}