package com.bcxin.flink.streaming.table.tasks;

import com.bcxin.event.core.FlinkJobAbstract;
import com.bcxin.event.core.JsonProvider;
import com.bcxin.event.core.JsonProviderImpl;
import com.bcxin.flink.streaming.cores.AppAbstract;
import com.bcxin.flink.streaming.cores.properties.CheckpointConfigProperty;
import com.bcxin.flink.streaming.cores.properties.StreamingConfigConstants;
import com.bcxin.flink.streaming.table.tasks.definitions.JobDataDefinition;
import com.bcxin.flink.streaming.table.tasks.jobs.ScriptDispatchJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.IOException;
import java.util.Properties;

public class StreamingTableApp extends AppAbstract {
    private static Logger logger = LoggerFactory.getLogger(StreamingTableApp.class);
    public static void main(String[] args) throws Exception {
        System.setProperty("org.slf4j.simpleLogger.defaultLogLevel", "info");
        if (args.length < 1) {
            throw new IllegalArgumentException("配置参数不能为空");
        }
        initEnv(args);
        JobDataDefinition definition = initJobDataDefinition(args[1]);

        FlinkJobAbstract job = new ScriptDispatchJob(definition);
        job.execute();
    }

    /**
     * 初始化参数配置
     * @param jobId
     * @throws IOException
     */
    private static JobDataDefinition initJobDataDefinition(String jobId) throws IOException {
        JsonProvider jsonProvider = new JsonProviderImpl();
        CheckpointConfigProperty configProperty = initCheckPointAndEnv(jsonProvider, jobId);
        Properties properties = System.getProperties();
        StreamingJobContext.init(properties.getProperty(StreamingConfigConstants.JOB_NAME), configProperty);
        String databasePropertyConf = getDatabasePropertyConfAfterInitEnv();

        JobDataDefinition definition = jsonProvider.toObject(JobDataDefinition.class, databasePropertyConf);

        return definition;
    }
}
