package com.bcxin.flink.data.webhook.tasks.components;

import com.bcxin.flink.data.webhook.tasks.datas.WebHoodApiDefinition;
import com.bcxin.flink.streaming.cores.dtos.DebeziumJsonNodeDto;
import com.google.common.collect.Queues;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.state.FunctionInitializationContext;
import org.apache.flink.runtime.state.FunctionSnapshotContext;
import org.apache.flink.streaming.api.checkpoint.CheckpointedFunction;
import org.apache.flink.streaming.api.functions.sink.RichSinkFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.Serializable;
import java.util.concurrent.*;
import java.util.concurrent.atomic.AtomicLong;

/**
 * https://blog.csdn.net/weixin_42073629/article/details/109193203
 */
public class MultiThreadConsumerSink extends RichSinkFunction<DebeziumJsonNodeDto> implements CheckpointedFunction , Serializable {

    private static final Logger logger = LoggerFactory.getLogger(MultiThreadConsumerSink.class);
    /**
     * Client线程的默认数量
     */
    private final int DEFAULT_CLIENT_THREAD_NUM=10;
    private final int DEFAULT_QUEUE_CAPACITY=5000;
    private final WebHoodApiDefinition webHoodApiDefinition;

    private LinkedBlockingQueue<DebeziumJsonNodeDto> bufferQueue;
    private CyclicBarrier cyclicBarrier;
    private final AtomicLong atomicLong = new AtomicLong(0);

    public MultiThreadConsumerSink(WebHoodApiDefinition webHoodApiDefinition) {
        this.webHoodApiDefinition = webHoodApiDefinition;
    }

    @Override
    public void open(Configuration parameters) throws Exception {
        super.open(parameters);
        logger.warn("执行当前的MultiThreadConsumerSink.open");
        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(DEFAULT_CLIENT_THREAD_NUM,
                DEFAULT_CLIENT_THREAD_NUM+2, 0, TimeUnit.MILLISECONDS, new LinkedBlockingDeque<>());
        threadPoolExecutor.setRejectedExecutionHandler(new RejectedExecutionHandler() {
            @Override
            public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
                logger.error("加入异常....");
            }
        });
        this.bufferQueue = Queues.newLinkedBlockingQueue(DEFAULT_QUEUE_CAPACITY);

        this.cyclicBarrier = new CyclicBarrier(DEFAULT_CLIENT_THREAD_NUM + 1);

        /**
         * 创建并开启消费者线程
         */
        MultiThreadConsumerClient consumerClient = new MultiThreadConsumerClient(bufferQueue, cyclicBarrier, webHoodApiDefinition);
        for (int index = 0; index < DEFAULT_CLIENT_THREAD_NUM; index++) {
            threadPoolExecutor.execute(consumerClient);
        }
    }

    @Override
    public void invoke(DebeziumJsonNodeDto value, Context context) throws Exception {
        Long current = atomicLong.incrementAndGet();
        if(current%9==1) {
            logger.error("索引={}: 当前用户为:{}; Id={}; 当前数={}", current, value.getAfter().get("NAME"), value.getKey(), current);
        }
        bufferQueue.put(value);

        super.invoke(value, context);
    }

    @Override
    public void snapshotState(FunctionSnapshotContext context) throws Exception {
        /**
         * 开始等待
         */
        //cyclicBarrier.await();
        logger.warn("执行当前的MultiThreadConsumerSink.snapshotState");
    }

    @Override
    public void initializeState(FunctionInitializationContext context) throws Exception {
        logger.warn("执行当前的MultiThreadConsumerSink.initializeState");
    }
}
