package com.bcxin.flink.data.webhook.tasks;

import com.bcxin.flink.streaming.cores.CoreJobContext;
import com.bcxin.flink.streaming.cores.properties.CheckpointConfigProperty;
import lombok.Getter;
import org.apache.commons.collections.MapUtils;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

@Getter
public class StreamingJobContext implements CoreJobContext,Serializable {
    private final String name;
    private final Map<String,String> flinkConfig;

    private StreamingJobContext(
            String name,
            CheckpointConfigProperty configProperty) {
        this.name = name;
        this.configProperty = configProperty;
        this.flinkConfig = new HashMap<>();
    }

    public void assign(HashMap<String,String> optionConfig) {
        if (MapUtils.isEmpty(optionConfig)) {
            return;
        }

        for (String key : optionConfig.keySet()) {
            this.getFlinkConfig().put(key, optionConfig.get(key));
        }
    }

    private final CheckpointConfigProperty configProperty;

    private static StreamingJobContext _instance;
    public static void init(
            String name,
            CheckpointConfigProperty configProperty) {
        if (_instance == null) {
            synchronized (StreamingJobContext.class) {
                if (_instance == null) {
                    _instance = new StreamingJobContext(name, configProperty);
                }
            }
        }
    }

    public static StreamingJobContext getInstance() {

        if (_instance == null) {
            throw new IllegalArgumentException("未对StreamingJobContext进行初始化操作");
        }

        return _instance;
    }
}
