package com.bcxin.flink.cdc.dispatch.task.proerpties;

import com.bcxin.flink.streaming.cores.properties.CheckpointConfigProperty;
import com.bcxin.flink.streaming.cores.properties.impls.DiskCheckpointConfigPropertyImpl;
import com.bcxin.flink.streaming.cores.properties.impls.HdfsCheckpointConfigPropertyImpl;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;

import java.io.IOException;
import java.util.Properties;

public class CheckpointConfigPropertyBuilder {
    public static CheckpointConfigProperty build(Properties properties) throws IOException {
        CheckpointConfigProperty configProperty = null;
        String mode = properties.getProperty(Constants.CHECKPOINT_MODE);
        switch (mode) {
            case Constants.CHECKPOINT_MODE_VALUE_FILE:
                configProperty = DiskCheckpointConfigPropertyImpl.create(
                        properties.getProperty(Constants.DISK_CHECKPOINT_LOCATION)
                );
                break;
            case Constants.CHECKPOINT_MODE_VALUE_HDFS:
                String coreSiteConfig = properties.getProperty(Constants.HDFS_CONF);
                Configuration.addDefaultResource(coreSiteConfig);
                Configuration conf = new Configuration();
                if (!StringUtils.isEmpty(properties.getProperty(Constants.HDFS_DEFAULT_FS))) {
                    conf.set(Constants.HDFS_DEFAULT_FS, properties.getProperty(Constants.HDFS_DEFAULT_FS));
                }
                if (!StringUtils.isEmpty(properties.getProperty(Constants.HDFS_CHECKPOINT_CONTEXT_PATH))) {
                    conf.set(Constants.HDFS_CHECKPOINT_CONTEXT_PATH, properties.getProperty(Constants.HDFS_CHECKPOINT_CONTEXT_PATH));
                }
                if (!StringUtils.isEmpty(properties.getProperty(Constants.HDFS_IPC_MAXIMUM_DATA_LENGTH))) {
                    conf.set(Constants.HDFS_IPC_MAXIMUM_DATA_LENGTH, properties.getProperty(Constants.HDFS_IPC_MAXIMUM_DATA_LENGTH));
                }
                if (!StringUtils.isEmpty(properties.getProperty(Constants.HDFS_IPC_MAXIMUM_RESPONSE_LENGTH))) {
                    conf.set(Constants.HDFS_IPC_MAXIMUM_RESPONSE_LENGTH,
                            properties.getProperty(Constants.HDFS_IPC_MAXIMUM_RESPONSE_LENGTH));
                }

                configProperty = HdfsCheckpointConfigPropertyImpl.create(
                        conf,
                        conf.get(Constants.HDFS_DEFAULT_FS),
                        conf.get(Constants.HDFS_CHECKPOINT_CONTEXT_PATH)
                );
                break;
        }

        return configProperty;
    }
}
