package com.bcxin.flink.cdc.dispatch.task.components;

import com.bcxin.event.core.JsonProvider;
import com.bcxin.event.core.JsonProviderImpl;
import com.bcxin.flink.cdc.dispatch.task.cdcs.CdcSourceMeta;
import com.bcxin.flink.cdc.dispatch.task.cdcs.ExecuteJobData;
import com.bcxin.flink.cdc.dispatch.task.enums.DispatchType;
import com.bcxin.flink.streaming.cores.JdbcJobExecutorUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpStatus;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.*;
import java.util.stream.Collectors;

public class CdcBinlog2DispatchComponent {
    private static final Logger logger = LoggerFactory.getLogger(CdcBinlog2DispatchComponent.class);
    public static void doExecute(Collection<CdcSourceMeta> sourceMetas) {
        List<ExecuteJobData> selectedChangedSqls = new ArrayList<>();

        for (CdcSourceMeta sourceMeta : sourceMetas) {
            switch (sourceMeta.getTableName().toLowerCase().trim()) {
                case "tenant_organizations":
                    selectedChangedSqls.add(
                            ExecuteJobData.create("call dispatch.proc_sync_rd_company_summary_by_company ('" + sourceMeta.getId() + "')",
                                    DispatchType.Company, sourceMeta, sourceMeta.getId()));
                    break;
                case "tlk_companyinformation":
                    selectedChangedSqls.add(
                            ExecuteJobData.create("call dispatch.proc_sync_rd_company_summary_by_company ('" + sourceMeta.getDomainId() + "')",
                                    DispatchType.Company, sourceMeta, sourceMeta.getId()));
                    break;
                case "tenant_users":
                    selectedChangedSqls.add(
                            ExecuteJobData.create("call dispatch.proc_sync_rd_employee_summary_by_tenant_user ('" + sourceMeta.getId() + "')",
                                    DispatchType.TenantUser, sourceMeta, sourceMeta.getId()));
                    break;
                case "tenant_employees":
                    selectedChangedSqls.add(
                            ExecuteJobData.create("call dispatch.proc_sync_rd_employee_summary_by_employee ('" + sourceMeta.getId() + "')",
                                    DispatchType.Employee, sourceMeta, sourceMeta.getId()));

                    if (sourceMeta.isEmployeeStatusChanged() && !StringUtils.isEmpty(sourceMeta.getDomainId())) {
                        selectedChangedSqls.add(
                                ExecuteJobData.create("call dispatch.proc_sync_rd_company_summary_by_company ('" + sourceMeta.getDomainId() + "')",
                                        DispatchType.Company, sourceMeta, sourceMeta.getId()));
                    } else {
                        logger.error("人员变更({}.{}={})变更无法无需通常统计(status={})公司信息",
                                sourceMeta.getDbName(), sourceMeta.getTableName(), sourceMeta.getId(), sourceMeta.isEmployeeStatusChanged());
                    }
                    break;
                case "tlk_attendance_site_base_info":
                    selectedChangedSqls.add(
                            ExecuteJobData.create("call dispatch.proc_sync_rd_security_station_summary_by_station ('" + sourceMeta.getId() + "')",
                                    DispatchType.Station, sourceMeta, sourceMeta.getId()));
                    break;
                case "tlk_attendance_site_person_info":
                    selectedChangedSqls.add(
                            ExecuteJobData.create("call dispatch.proc_sync_rd_security_station_summary_by_station ('" + sourceMeta.getId() + "')",
                                    DispatchType.Station, sourceMeta, sourceMeta.getId()));
                    String employeeId = sourceMeta.getSecurityId();
                    if (!StringUtils.isEmpty(employeeId)) {
                        selectedChangedSqls.add(
                                ExecuteJobData.create("call dispatch.proc_sync_rd_security_station_summary_by_station ('" + sourceMeta.getId() + "')",
                                        DispatchType.Employee, sourceMeta, sourceMeta.getId()));
                    } else {
                        logger.error("驻勤人2员({}.{}={})变更无法正常影响到职员信息", sourceMeta.getDbName(), sourceMeta.getTableName(), sourceMeta.getId());
                    }
                    break;
                default: {
                    logger.error(String.format("无效2:暂不支持无效(%s)归集数据类型:%s", sourceMeta.getOriginalValue(),
                            sourceMeta.getTableName()));
                }
            }
        }

        try (Connection connection = JdbcJobExecutorUtil.getConnection()) {
            connection.setAutoCommit(false);
            for (int index = 0; index < selectedChangedSqls.size(); index++) {
                ExecuteJobData item = selectedChangedSqls.get(index);
                try (PreparedStatement statement = connection.prepareStatement(item.getSql())) {
                    statement.addBatch();
                    int affectedCount = 0;
                    Object paramIds = item.getParmaId();
                    affectedCount = statement.executeUpdate();
                } catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
             connection.commit();
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
        logger.error("存储过程执行完毕：{}", sourceMetas.stream().map(ix -> ix.getId()).collect(Collectors.joining(";")));
        //doWebHookApi(paramIds, item.getDispatchType(), affectedCount);
    }

    private static boolean doWebHookApi(Object paramId,DispatchType dispatchType, int affectedCount) {
        /**
         * 更新redis
         */
        String api = getRestApi();

        String body = null;
        try {
            String dataType = "";
            switch (dispatchType) {
                case Employee:
                case TenantUser:
                    dataType = "Employee";
                    break;
                case Station:
                    dataType = "Station";
                    break;
                case Company:
                    dataType = "Company";
                    break;
            }

            JsonProvider jsonProvider = new JsonProviderImpl();
            /**
             * 参数
             */
            Map<String, Collection> requestParam = new HashMap<>();
            Map<String, Object> requestItem = new HashMap<>();
            requestItem.put("dataType", dataType);
            if(dispatchType==DispatchType.TenantUser)
            {
                Collection<String> employeeIds = (Collection<String>)paramId;
                requestItem.put("ids", employeeIds);
            }else {
                requestItem.put("ids", Collections.singleton(paramId));
            }

            requestParam.put("contents", Collections.singleton(requestItem));
            /**
             * 参数
             */
            body = jsonProvider.getJson(requestParam);

            HttpPost post = new HttpPost(api);
            AbstractHttpEntity httpEntity = new StringEntity(body, "UTF-8");
            httpEntity.setContentEncoding(StandardCharsets.UTF_8.toString());
            httpEntity.setContentEncoding("application/json");
            post.setEntity(httpEntity);
            post.addHeader("Content-Type", "application/json");

            try(CloseableHttpClient httpClient = HttpClients.createDefault()) {
                try (CloseableHttpResponse response = httpClient.execute(post)) {
                    StatusLine statusLine = response.getStatusLine();

                    if (statusLine.getStatusCode() != HttpStatus.SC_OK) {
                        String content = EntityUtils.toString(response.getEntity());

                        logger.error("{}: 执行结束(总数量={},DB操作影响数={}):{} 失败-状态:{} 请求-{}; 响应:{}",
                                Thread.currentThread().getId(),
                                1,affectedCount,
                                api,
                                statusLine.getStatusCode(),
                                body,
                                content);
                    } else {
                        logger.error("{}: 成功-执行结束(总数量={},DB操作影响数={}):{} 参数={} Ok-响应:{}",
                                Thread.currentThread().getId(),
                                1,affectedCount,
                                api,
                                body, statusLine.getStatusCode());
                    }
                }
            }
        } catch (Exception ex) {
            logger.error("自动同步功能异常({}):: api={},body={},error={}", dispatchType, api, body, ex.getMessage());
            ex.printStackTrace();
        }

        logger.error("影响的数据({}):id={},affectedCount={}",dispatchType,  paramId, affectedCount);

        return false;
    }

    public static String getRestApi() {
        if ("com-prod".equalsIgnoreCase(System.getProperty("dispatch.env"))) {
            return "https://v5qy.baibaodun.cn/dispatch/flush/request";
        }

        return "https://v5qy.te.baibaodun.com.cn/dispatch/flush/request";
    }
}
