package com.bcxin.flink.cdc.dispatch.task.cdcs;

import com.bcxin.flink.cdc.dispatch.task.enums.DispatchType;
import lombok.Getter;

import java.io.Serializable;

@Getter
public class ExecuteJobData implements Serializable {
    private final String sql;
    private final DispatchType dispatchType;

    private final CdcSourceMeta sourceMeta;

    private final String parmaId;

    public ExecuteJobData(String sql, DispatchType dispatchType, CdcSourceMeta sourceMeta, String parmaId) {
        this.sql = sql;
        this.dispatchType = dispatchType;
        this.sourceMeta = sourceMeta;
        this.parmaId = parmaId;
    }

    public static ExecuteJobData create(String sql, DispatchType dispatchTyp, CdcSourceMeta sourceMeta, String parmaId) {
        return new ExecuteJobData(sql, dispatchTyp, sourceMeta, parmaId);
    }
}
