/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.event.job.core.domain.dtos;

import java.io.Serializable;

public class RedisConfig
implements Serializable {
    private String host;
    private String password;
    private int port;
    private int timout;

    public static RedisConfig create(String host, int port, int timeout, String password) {
        RedisConfig config = new RedisConfig();
        config.setHost(host);
        config.setPort(port);
        config.setPassword(password);
        config.setTimout(timeout);
        return config;
    }

    public static RedisConfig getDefaultFromMainThread() {
        String host = System.getProperty("redis.host");
        String port = System.getProperty("redis.port");
        String timout = System.getProperty("redis.timout");
        String password = System.getProperty("redis.password");
        return RedisConfig.create(host, Integer.parseInt(port), Integer.parseInt(timout), password);
    }

    public String getHost() {
        return this.host;
    }

    public String getPassword() {
        return this.password;
    }

    public int getPort() {
        return this.port;
    }

    public int getTimout() {
        return this.timout;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setTimout(int timout) {
        this.timout = timout;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RedisConfig)) {
            return false;
        }
        RedisConfig other = (RedisConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPort() != other.getPort()) {
            return false;
        }
        if (this.getTimout() != other.getTimout()) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        return !(this$password == null ? other$password != null : !this$password.equals(other$password));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RedisConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPort();
        result = result * 59 + this.getTimout();
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        return result;
    }

    public String toString() {
        return "RedisConfig(host=" + this.getHost() + ", password=" + this.getPassword() + ", port=" + this.getPort() + ", timout=" + this.getTimout() + ")";
    }
}

