/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.event.core.definitions;

import com.bcxin.event.core.definitions.ConnectorDefinitionAbstract;
import org.apache.commons.lang3.StringUtils;

public class KafkaTopicConnectorDefinition
extends ConnectorDefinitionAbstract {
    private static final String KAFKA_SOURCE_PRIMARY_KEY_NAME = "id";
    private String name;
    private String connector;
    private String bootstrapServer;
    private String topic;
    private String consumerGroupId;
    private String autoOffsetRest = "earliest";
    private String scanStartupMode = "group-offsets";
    private String enableAutoCommit = "true";
    private String primaryKeyName = "id";
    private String format;

    @Override
    public String getConnector() {
        return "kafka";
    }

    public String getDefinitionMeta() {
        return String.format("'connector' = '%s','properties.group.id'='%s','topic' = '%s','properties.bootstrap.servers' = '%s','scan.startup.mode' = 'latest-offset','format'='%s'", StringUtils.isEmpty((CharSequence)this.getConnector()) ? "kafka" : this.getConnector(), this.getConsumerGroupId(), this.getTopic(), this.getBootstrapServer(), StringUtils.isEmpty((CharSequence)this.getFormat()) ? "debezium-json" : this.getFormat());
    }

    public String getPrimaryKeyName() {
        if (StringUtils.isEmpty((CharSequence)this.primaryKeyName)) {
            return KAFKA_SOURCE_PRIMARY_KEY_NAME;
        }
        return this.primaryKeyName;
    }

    public String getName() {
        return this.name;
    }

    public String getBootstrapServer() {
        return this.bootstrapServer;
    }

    public String getTopic() {
        return this.topic;
    }

    public String getConsumerGroupId() {
        return this.consumerGroupId;
    }

    public String getAutoOffsetRest() {
        return this.autoOffsetRest;
    }

    public String getScanStartupMode() {
        return this.scanStartupMode;
    }

    public String getEnableAutoCommit() {
        return this.enableAutoCommit;
    }

    public String getFormat() {
        return this.format;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setConnector(String connector) {
        this.connector = connector;
    }

    public void setBootstrapServer(String bootstrapServer) {
        this.bootstrapServer = bootstrapServer;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public void setConsumerGroupId(String consumerGroupId) {
        this.consumerGroupId = consumerGroupId;
    }

    public void setAutoOffsetRest(String autoOffsetRest) {
        this.autoOffsetRest = autoOffsetRest;
    }

    public void setScanStartupMode(String scanStartupMode) {
        this.scanStartupMode = scanStartupMode;
    }

    public void setEnableAutoCommit(String enableAutoCommit) {
        this.enableAutoCommit = enableAutoCommit;
    }

    public void setPrimaryKeyName(String primaryKeyName) {
        this.primaryKeyName = primaryKeyName;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KafkaTopicConnectorDefinition)) {
            return false;
        }
        KafkaTopicConnectorDefinition other = (KafkaTopicConnectorDefinition)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$connector = this.getConnector();
        String other$connector = other.getConnector();
        if (this$connector == null ? other$connector != null : !this$connector.equals(other$connector)) {
            return false;
        }
        String this$bootstrapServer = this.getBootstrapServer();
        String other$bootstrapServer = other.getBootstrapServer();
        if (this$bootstrapServer == null ? other$bootstrapServer != null : !this$bootstrapServer.equals(other$bootstrapServer)) {
            return false;
        }
        String this$topic = this.getTopic();
        String other$topic = other.getTopic();
        if (this$topic == null ? other$topic != null : !this$topic.equals(other$topic)) {
            return false;
        }
        String this$consumerGroupId = this.getConsumerGroupId();
        String other$consumerGroupId = other.getConsumerGroupId();
        if (this$consumerGroupId == null ? other$consumerGroupId != null : !this$consumerGroupId.equals(other$consumerGroupId)) {
            return false;
        }
        String this$autoOffsetRest = this.getAutoOffsetRest();
        String other$autoOffsetRest = other.getAutoOffsetRest();
        if (this$autoOffsetRest == null ? other$autoOffsetRest != null : !this$autoOffsetRest.equals(other$autoOffsetRest)) {
            return false;
        }
        String this$scanStartupMode = this.getScanStartupMode();
        String other$scanStartupMode = other.getScanStartupMode();
        if (this$scanStartupMode == null ? other$scanStartupMode != null : !this$scanStartupMode.equals(other$scanStartupMode)) {
            return false;
        }
        String this$enableAutoCommit = this.getEnableAutoCommit();
        String other$enableAutoCommit = other.getEnableAutoCommit();
        if (this$enableAutoCommit == null ? other$enableAutoCommit != null : !this$enableAutoCommit.equals(other$enableAutoCommit)) {
            return false;
        }
        String this$primaryKeyName = this.getPrimaryKeyName();
        String other$primaryKeyName = other.getPrimaryKeyName();
        if (this$primaryKeyName == null ? other$primaryKeyName != null : !this$primaryKeyName.equals(other$primaryKeyName)) {
            return false;
        }
        String this$format = this.getFormat();
        String other$format = other.getFormat();
        return !(this$format == null ? other$format != null : !this$format.equals(other$format));
    }

    protected boolean canEqual(Object other) {
        return other instanceof KafkaTopicConnectorDefinition;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $connector = this.getConnector();
        result = result * 59 + ($connector == null ? 43 : $connector.hashCode());
        String $bootstrapServer = this.getBootstrapServer();
        result = result * 59 + ($bootstrapServer == null ? 43 : $bootstrapServer.hashCode());
        String $topic = this.getTopic();
        result = result * 59 + ($topic == null ? 43 : $topic.hashCode());
        String $consumerGroupId = this.getConsumerGroupId();
        result = result * 59 + ($consumerGroupId == null ? 43 : $consumerGroupId.hashCode());
        String $autoOffsetRest = this.getAutoOffsetRest();
        result = result * 59 + ($autoOffsetRest == null ? 43 : $autoOffsetRest.hashCode());
        String $scanStartupMode = this.getScanStartupMode();
        result = result * 59 + ($scanStartupMode == null ? 43 : $scanStartupMode.hashCode());
        String $enableAutoCommit = this.getEnableAutoCommit();
        result = result * 59 + ($enableAutoCommit == null ? 43 : $enableAutoCommit.hashCode());
        String $primaryKeyName = this.getPrimaryKeyName();
        result = result * 59 + ($primaryKeyName == null ? 43 : $primaryKeyName.hashCode());
        String $format = this.getFormat();
        result = result * 59 + ($format == null ? 43 : $format.hashCode());
        return result;
    }

    public String toString() {
        return "KafkaTopicConnectorDefinition(name=" + this.getName() + ", connector=" + this.getConnector() + ", bootstrapServer=" + this.getBootstrapServer() + ", topic=" + this.getTopic() + ", consumerGroupId=" + this.getConsumerGroupId() + ", autoOffsetRest=" + this.getAutoOffsetRest() + ", scanStartupMode=" + this.getScanStartupMode() + ", enableAutoCommit=" + this.getEnableAutoCommit() + ", primaryKeyName=" + this.getPrimaryKeyName() + ", format=" + this.getFormat() + ")";
    }
}

