/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.event.core.definitions;

import com.bcxin.event.core.definitions.ConnectorDefinitionAbstract;
import com.bcxin.event.core.exceptions.IllegalArgumentEventException;
import org.apache.commons.lang3.StringUtils;

public class JdbcConnectorDefinition
extends ConnectorDefinitionAbstract {
    private String url;
    private String username;
    private String password;
    private String tableName;
    private String connectionTimeZone;

    @Override
    public String getConnector() {
        return "jdbc";
    }

    public String getJdbcDefinitionMeta() {
        if (StringUtils.isEmpty((CharSequence)this.getTableName())) {
            throw new IllegalArgumentEventException(String.format("JdbcConnectorDefinition(%s)\u7684TableName\u4e0d\u80fd\u4e3a\u7a7a", this.getUrl()));
        }
        return String.format("'connector' = '%s','url'='%s','username'='%s','password'='%s','table-name'='%s'", this.getConnector(), this.getUrl(), this.getUsername(), this.getPassword(), this.getTableName());
    }

    public String getUniqueKey() {
        return String.format("%s-%s", this.getUrl(), this.getUsername());
    }

    public String getUrl() {
        return this.url;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getConnectionTimeZone() {
        return this.connectionTimeZone;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setConnectionTimeZone(String connectionTimeZone) {
        this.connectionTimeZone = connectionTimeZone;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JdbcConnectorDefinition)) {
            return false;
        }
        JdbcConnectorDefinition other = (JdbcConnectorDefinition)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$tableName = this.getTableName();
        String other$tableName = other.getTableName();
        if (this$tableName == null ? other$tableName != null : !this$tableName.equals(other$tableName)) {
            return false;
        }
        String this$connectionTimeZone = this.getConnectionTimeZone();
        String other$connectionTimeZone = other.getConnectionTimeZone();
        return !(this$connectionTimeZone == null ? other$connectionTimeZone != null : !this$connectionTimeZone.equals(other$connectionTimeZone));
    }

    protected boolean canEqual(Object other) {
        return other instanceof JdbcConnectorDefinition;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $tableName = this.getTableName();
        result = result * 59 + ($tableName == null ? 43 : $tableName.hashCode());
        String $connectionTimeZone = this.getConnectionTimeZone();
        result = result * 59 + ($connectionTimeZone == null ? 43 : $connectionTimeZone.hashCode());
        return result;
    }

    public String toString() {
        return "JdbcConnectorDefinition(url=" + this.getUrl() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ", tableName=" + this.getTableName() + ", connectionTimeZone=" + this.getConnectionTimeZone() + ")";
    }
}

