/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.event.core.jdbc;

import com.bcxin.event.core.jdbc.JdbcNameParameterSqlParser;
import com.bcxin.event.core.jdbc.ParseSqlParameter;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.jdbc.core.PreparedStatementCreatorFactory;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterUtils;
import org.springframework.jdbc.core.namedparam.ParsedSql;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

public class JdbcNameParameterSqlParserImpl
implements JdbcNameParameterSqlParser {
    public static final int DEFAULT_CACHE_LIMIT = 256;
    private volatile int cacheLimit = 256;
    private final Map<String, ParsedSql> parsedSqlCache = new LinkedHashMap<String, ParsedSql>(256, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, ParsedSql> eldest) {
            return this.size() > JdbcNameParameterSqlParserImpl.this.getCacheLimit();
        }
    };

    public int getCacheLimit() {
        return this.cacheLimit;
    }

    @Override
    public ParseSqlParameter parse(String sql) {
        ParsedSql parsedSql = this.getParsedSql(sql);
        PreparedStatementCreatorFactory pscf = this.getPreparedStatementCreatorFactory(parsedSql, (SqlParameterSource)new MapSqlParameterSource(){});
        return ParseSqlParameter.create(parsedSql, pscf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ParsedSql getParsedSql(String sql) {
        if (this.getCacheLimit() <= 0) {
            return NamedParameterUtils.parseSqlStatement((String)sql);
        }
        Map<String, ParsedSql> map = this.parsedSqlCache;
        synchronized (map) {
            return this.parsedSqlCache.computeIfAbsent(sql, NamedParameterUtils::parseSqlStatement);
        }
    }

    protected PreparedStatementCreatorFactory getPreparedStatementCreatorFactory(ParsedSql parsedSql, SqlParameterSource paramSource) {
        String sqlToUse = NamedParameterUtils.substituteNamedParameters((ParsedSql)parsedSql, (SqlParameterSource)paramSource);
        List declaredParameters = NamedParameterUtils.buildSqlParameterList((ParsedSql)parsedSql, (SqlParameterSource)paramSource);
        return new PreparedStatementCreatorFactory(sqlToUse, declaredParameters);
    }
}

