/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.event.core.utils;

import com.bcxin.event.core.exceptions.AffectedEventException;
import com.bcxin.event.core.exceptions.BadEventException;
import com.bcxin.event.core.exceptions.SkipRetryEventException;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryUtil {
    private static final Logger logger = LoggerFactory.getLogger(RetryUtil.class);

    public static <T> T execute(Callable<T> function, int retryCount) {
        int maxRetries = retryCount;
        if (maxRetries < 1) {
            maxRetries = 1;
        }
        try {
            for (int i = 0; i < maxRetries; ++i) {
                try {
                    return function.call();
                }
                catch (Exception e) {
                    if (i == maxRetries - 1) {
                        throw e;
                    }
                    if (e instanceof SkipRetryEventException) {
                        throw e;
                    }
                    if (e instanceof AffectedEventException) {
                        throw e;
                    }
                    Thread.sleep(800L);
                    continue;
                }
            }
        }
        catch (Exception ex) {
            if (ex instanceof SkipRetryEventException) {
                throw (SkipRetryEventException)ex;
            }
            if (ex instanceof AffectedEventException) {
                throw (AffectedEventException)ex;
            }
            throw new BadEventException(String.format("\u8fbe\u5230\u91cd\u8bd5\u6700\u5927\u9650\u5236(%s)-%s", retryCount, ex.getMessage()), ex);
        }
        return null;
    }

    public static <T> T execute(Callable<T> function) {
        return RetryUtil.execute(function, 2);
    }
}

