/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.event.core;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.bcxin.event.core.JsonProvider;
import java.io.Serializable;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonProviderImpl
implements JsonProvider,
Serializable {
    private static final Logger logger = LoggerFactory.getLogger(JsonProviderImpl.class);

    @Override
    public String getJson(Object data) {
        return JSON.toJSONString((Object)data);
    }

    @Override
    public <T> T toObject(Class<T> tClass, String json) {
        try {
            return (T)JSON.parseObject((String)json, tClass);
        }
        catch (Exception ex) {
            logger.error("failed to toObject:{}", (Object)json, (Object)ex);
            throw ex;
        }
    }

    @Override
    public <T> Collection<T> toCollection(Class<T> tClass, String json) {
        try {
            return JSON.parseArray((String)json, tClass);
        }
        catch (Exception ex) {
            logger.error("failed to toCollection:{}", (Object)json, (Object)ex);
            throw ex;
        }
    }

    @Override
    public String getJson(Object data, boolean ignoreEmpty) {
        if (data == null) {
            return null;
        }
        String result = JSON.toJSONString((Object)data, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
        if (result == null) {
            return result;
        }
        return result.replace(":\"null\"", ":null");
    }
}

