/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.event.core;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.event.core.KafkaConstants;
import com.bcxin.event.core.utils.StringUtils;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlinkConstants {
    private static final Logger logger = LoggerFactory.getLogger(FlinkConstants.class);
    private static final Collection<String> SYS_DATETIME_FIELD_NAMES = Stream.of("LASTMODIFIED", "CREATED").collect(Collectors.toList());
    private static final Collection<String> DATETIME_FIELD_NAMES = Stream.of("TIME", "DATE", "FZRQ", "FIRST_ISSUE_SERVICE_PERMIT").collect(Collectors.toList());
    public static final String REDIS_HMAP_DB_NAME_FORMAT = "%s:%s:%s_%s";
    public static final String EMPLOYEE_STATION_ID = "security_station_id";
    public static final String EMPLOYEE_STATION_NAME = "security_station_name";
    public static final String EMPLOYEE_STATION_SUPERVISE_DEPART_ID = "security_supervise_depart_id";
    public static final String EMPLOYEE_STATION_SUPERVISE_DEPART_ID_INDEX = "security_supervise_depart_id_index";
    public static final String EMPLOYEE_STATION_SUPERVISE_DEPART_NAME = "security_supervise_depart_name";
    public static final String SUPERVISE_DEPART_ID = "supervise_depart_id";
    public static final String SUPERVISE_DEPART_NAME = "supervise_depart_name";
    public static final String SUPERVISE_REGIONId = "supervise_region_id";

    public static int getCalculatedParallelism() {
        int value = (int)Math.ceil(0.6);
        if (value < 5) {
            value = 5;
        }
        if (value > 10) {
            value = 10;
        }
        return value;
    }

    public static String formatValue(String nodeKey, String nodeValue) {
        if (nodeValue == null) {
            return null;
        }
        if (nodeValue instanceof String) {
            String bsStr = nodeValue;
            if (FlinkConstants.isDateTimeField(nodeKey) && (bsStr.contains("0000-00-00") || bsStr.contains("9999-"))) {
                return null;
            }
        }
        try {
            if (FlinkConstants.isDateTimeField(nodeKey)) {
                if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)nodeValue) && !nodeValue.contains("-") && org.apache.commons.lang3.StringUtils.isNumeric((CharSequence)nodeValue)) {
                    return new SimpleDateFormat("yyyy-MM-dd hh:mm:ss").format(new Date(FlinkConstants.getTimeValue(nodeKey, nodeValue)));
                }
                if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)nodeValue) || StringUtils.hasAlpha(nodeValue)) {
                    return null;
                }
                if (nodeValue.contains("999-") || nodeValue.contains("000-")) {
                    return null;
                }
                return nodeValue;
            }
        }
        catch (Exception ex) {
            logger.error("\u53ef\u5ffd\u7565: formatValue.key={};value={};\u8f6c\u6362\u51fa\u9519=%s;\u5c1d\u8bd5\u8f6c\u4e3aDouble", new Object[]{nodeKey, nodeValue, ex});
            ex.printStackTrace();
        }
        return nodeValue;
    }

    public static long getTimeValue(String key, Object value) {
        try {
            return Long.parseLong(String.valueOf(value));
        }
        catch (Exception ex) {
            try {
                return (long)Double.parseDouble(String.valueOf(value));
            }
            catch (Exception e) {
                return 0L;
            }
        }
    }

    public static boolean isDateTimeField(String nodeKey) {
        return SYS_DATETIME_FIELD_NAMES.stream().anyMatch(ix -> ix.equalsIgnoreCase(nodeKey)) || DATETIME_FIELD_NAMES.stream().anyMatch(ix -> nodeKey.toUpperCase().contains((CharSequence)ix));
    }

    public static String getCalculatedParallelismKey(String value) {
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)value)) {
            return value;
        }
        int maxParallelismCount = 3;
        int parallelValue = KafkaConstants.getCalculableHashValue(Math.abs(value.hashCode())) % 3;
        return String.valueOf(parallelValue);
    }

    public static String getExtractedParallelismOriginalKey(JSONObject dataNode) {
        Object parallelismKeyValue = null;
        StringBuilder sb = new StringBuilder();
        Optional<String> keyOptional = dataNode.keySet().stream().filter(ix -> ix.equalsIgnoreCase("domainId") || ix.replace("_", "").equalsIgnoreCase("organizationId")).findFirst();
        sb.append(String.format("\u7b2c\u4e00\u4e2akeyOption=%s", keyOptional));
        if (keyOptional.isPresent()) {
            parallelismKeyValue = dataNode.get((Object)keyOptional.get());
            sb.append(String.format("\u7b2c\u4e00\u4e2akeyOption\u7684\u503c=%s", parallelismKeyValue));
        } else {
            keyOptional = dataNode.keySet().stream().filter(ix -> ix.equalsIgnoreCase("tenant_user_id")).findFirst();
            sb.append(String.format("\u7b2c\u4e8c\u4e2akeyOption=%s", keyOptional));
            if (keyOptional.isPresent()) {
                parallelismKeyValue = dataNode.get((Object)keyOptional.get());
                sb.append(String.format("\u7b2c\u4e8c\u4e2akeyOption\u7684\u503c=%s", parallelismKeyValue));
            } else {
                keyOptional = dataNode.keySet().stream().filter(ix -> ix.equalsIgnoreCase("id") || ix.replace("_", "").equalsIgnoreCase("pkId")).findFirst();
                sb.append(String.format("\u7b2c\u4e09\u4e2akeyOption=%s", keyOptional));
                if (keyOptional.isPresent()) {
                    parallelismKeyValue = dataNode.get((Object)keyOptional.get());
                    sb.append(String.format("\u7b2c\u4e09\u4e2akeyOption\u7684\u503c=%s", parallelismKeyValue));
                }
            }
        }
        if (parallelismKeyValue == null) {
            keyOptional = dataNode.keySet().stream().filter(ix -> ix.equalsIgnoreCase("id") || ix.equalsIgnoreCase("tenant_user_id")).findFirst();
            sb.append(String.format("\u7b2c\u56db\u4e2akeyOption=%s", keyOptional));
            if (keyOptional.isPresent()) {
                parallelismKeyValue = dataNode.get((Object)keyOptional.get());
                sb.append(String.format("\u7b2c\u4e09\u4e2akeyOption\u7684\u503c=%s", parallelismKeyValue));
            }
            if (parallelismKeyValue == null) {
                Object id = dataNode.get((Object)"id");
                if (id == null) {
                    logger.info(sb + ";\u53d6\u9ed8\u8ba4default(=NULL)\u65e0\u6548\u503c\u65e0\u6548V5\u7684\u5206\u533a\u9009\u9879: " + JSON.toJSONString((Object)dataNode));
                    return "default";
                }
                return String.valueOf(id);
            }
        }
        return String.valueOf(parallelismKeyValue);
    }
}

