/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.event.core;

import com.bcxin.event.core.JobExecutorParam;
import com.bcxin.event.core.JsonProvider;
import com.bcxin.event.core.enums.JobType;

public class JobParameterDTO {
    public static final String JDBC_DATASOURCE_NAME = "datasource.name";
    public static final String JDBC_DATASOURCE_DRIVER_NAME = "datasource.driver-class-name";
    public static final String JDBC_DATASOURCE_URL = "datasource.url";
    public static final String JDBC_DATASOURCE_USERNAME = "datasource.username";
    public static final String JDBC_DATASOURCE_PASSWORD = "datasource.password";
    private final String name;
    private final String parameterJson;
    private final String description;
    private final JobType jobType;
    private JobExecutorParam param;

    public JobParameterDTO(String name, JobType jobType, String parameterJson, String description) {
        this.name = name;
        this.parameterJson = parameterJson;
        this.description = description;
        this.jobType = jobType;
    }

    public static JobParameterDTO create(String name, JobType jobType, String parameterJson, String description) {
        return new JobParameterDTO(name, jobType, parameterJson, description);
    }

    public String getParam1(JsonProvider jsonProvider) {
        JobExecutorParam p = this.getJobExecutorParam(jsonProvider);
        if (p == null) {
            return null;
        }
        return p.getParam1();
    }

    public String getParam2(JsonProvider jsonProvider) {
        JobExecutorParam p = this.getJobExecutorParam(jsonProvider);
        if (p == null) {
            return null;
        }
        return p.getParam2();
    }

    private JobExecutorParam getJobExecutorParam(JsonProvider jsonProvider) {
        if (this.getParam() == null) {
            this.param = jsonProvider.toObject(JobExecutorParam.class, this.getParameterJson());
        }
        return this.param;
    }

    public String getName() {
        return this.name;
    }

    public String getParameterJson() {
        return this.parameterJson;
    }

    public String getDescription() {
        return this.description;
    }

    public JobType getJobType() {
        return this.jobType;
    }

    private JobExecutorParam getParam() {
        return this.param;
    }
}

