/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.event.job.core.domain.impls;

import com.bcxin.event.core.exceptions.BadEventException;
import com.bcxin.event.core.exceptions.NoSupportEventException;
import com.bcxin.event.job.core.domain.CacheDataProcessor;
import com.bcxin.event.job.core.domain.CacheProvider;
import com.bcxin.event.job.core.domain.CacheTableConstant;
import com.bcxin.event.job.core.domain.DockMapDbExtractor;
import com.bcxin.event.job.core.domain.JedisPoolFactory;
import com.bcxin.event.job.core.domain.documents.enums.DocumentType;
import com.bcxin.event.job.core.domain.dtos.BinlogMapDTO;
import com.bcxin.event.job.core.domain.dtos.DocumentExpiredDTO;
import com.bcxin.event.job.core.domain.dtos.RedisConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.Pipeline;

public class CacheProviderImpl
implements CacheProvider {
    private static Logger logger = LoggerFactory.getLogger(CacheProviderImpl.class);
    private static ThreadLocal<Pipeline> _currentThreadLocalPipeline = new InheritableThreadLocal<Pipeline>();
    private static ThreadLocal<Jedis> _currentThreadLocalJedisWriter = new InheritableThreadLocal<Jedis>();
    private final RedisConfig redisConfig;

    public CacheProviderImpl(RedisConfig redisConfig) {
        this.redisConfig = redisConfig;
    }

    private Pipeline beginMulti(Jedis selectedJedis) {
        Pipeline pipeline = _currentThreadLocalPipeline.get();
        if (pipeline != null) {
            throw new BadEventException("\u6b64\u65f6\u7684Pipline\u7684\u503c\u5e94\u8be5\u4e0d\u4e3a\u7a7a\u624d\u662f");
        }
        pipeline = selectedJedis.pipelined();
        _currentThreadLocalPipeline.set(pipeline);
        return pipeline;
    }

    private Pipeline getPipeline() {
        Pipeline pipeline = _currentThreadLocalPipeline.get();
        if (pipeline == null) {
            throw new NoSupportEventException();
        }
        return pipeline;
    }

    private Jedis getSelectedJedisWriter() {
        return _currentThreadLocalJedisWriter.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void upset(BinlogMapDTO data) {
        if (data == null || data.getDocumentType() == null) {
            return;
        }
        try (Jedis selectedJedis = JedisPoolFactory.getNewJedisResource(this.redisConfig);){
            try (Jedis selectedJedisForReadonly = JedisPoolFactory.getNewJedisResource(this.redisConfig);){
                _currentThreadLocalJedisWriter.set(selectedJedis);
                ArrayList<String> includeColumnNames = new ArrayList<String>();
                includeColumnNames.add("id");
                includeColumnNames.add("name");
                includeColumnNames.add("status");
                try (Pipeline pipeline = this.beginMulti(selectedJedis);){
                    switch (data.getDocumentType()) {
                        case Organization: {
                            CacheDataProcessor.processOrganizationSuperviseDepartmentLevelInfo(this, data.getBefore(), data.getContent(), data.getDocumentType(), data.getId());
                            includeColumnNames.add("approved_information_status");
                            includeColumnNames.add("supervise_region_code");
                            includeColumnNames.add("supervise_depart_id");
                            includeColumnNames.add("supervise_depart_name");
                            includeColumnNames.add("place_of_business");
                            includeColumnNames.add("place_of_register");
                            includeColumnNames.add("type");
                            break;
                        }
                        case User_Credentials: {
                            CacheDataProcessor.processUserCredentials(this, data.getBefore(), data.getContent(), data.getDocumentType(), data.getId());
                            includeColumnNames.add("number");
                            includeColumnNames.add("head_photo");
                            includeColumnNames.add("front_photo");
                            includeColumnNames.add("reverse_photo");
                            includeColumnNames.add("valid_date_from");
                            includeColumnNames.add("valid_date_to");
                            includeColumnNames.add("tenant_user_id");
                            includeColumnNames.add("credential_type");
                            includeColumnNames.add("selected");
                            break;
                        }
                        case Department: {
                            break;
                        }
                        case Employee: {
                            CacheDataProcessor.processEmployeeData(this, data.getBefore(), data.getContent(), data.getDocumentType(), data.getId());
                            includeColumnNames.add("hired_date");
                            includeColumnNames.add("leave_");
                            includeColumnNames.add("is_domain_admin");
                            includeColumnNames.add("hired_");
                            break;
                        }
                        case SecurityStation: {
                            CacheDataProcessor.processSecurityStation(this, data.getBefore(), data.getContent(), data.getDocumentType(), data.getId(), data.getDomainId());
                            includeColumnNames.add("ITEM_attendanceSiteName");
                            includeColumnNames.add("ITEM_attendanceSiteType");
                            includeColumnNames.add("ITEM_attendanceSiteState");
                            includeColumnNames.add("ITEM_contractStartDate");
                            includeColumnNames.add("ITEM_contractEndDate");
                            break;
                        }
                        case SecurityStationPerson: {
                            CacheDataProcessor.processSecurityStationPerson(this, data.getBefore(), data.getContent(), data.getDocumentType(), data.getId(), data.getDomainId());
                            includeColumnNames.add("ITEM_attendanceSiteId");
                        }
                    }
                    if (data.getDocumentType() != null) {
                        String id = data.getId();
                        Map<String, String> value = data.getContent();
                        Map<String, String> before = data.getBefore();
                        this.update(data.getDocumentType(), id, value);
                        if (this.getPipeline() != null) {
                            this.getPipeline().set(CacheTableConstant.getSyncKey(data.getDocumentType()), String.valueOf(data.getSyncVersion()));
                        } else {
                            selectedJedis.set(CacheTableConstant.getSyncKey(data.getDocumentType()), String.valueOf(data.getSyncVersion()));
                        }
                    }
                    List list = pipeline.syncAndReturnAll();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    throw ex;
                }
            }
            finally {
                _currentThreadLocalPipeline.set(null);
                _currentThreadLocalJedisWriter.set(null);
            }
        }
    }

    @Override
    public void update(DocumentType documentType, String id, Map<String, String> data) {
        if (data == null) {
            return;
        }
        for (String key : data.keySet()) {
            String value = data.get(key);
            if (value == null) {
                if (this.getPipeline() != null) {
                    this.getPipeline().hdel(CacheTableConstant.getRedisHashKey(documentType, id), new String[]{key});
                    continue;
                }
                this.getSelectedJedisWriter().hdel(CacheTableConstant.getRedisHashKey(documentType, id), new String[]{key});
                continue;
            }
            if (this.getPipeline() != null) {
                this.getPipeline().hset(CacheTableConstant.getRedisHashKey(documentType, id), key, value);
                continue;
            }
            this.getSelectedJedisWriter().hset(CacheTableConstant.getRedisHashKey(documentType, id), key, value);
        }
    }

    @Override
    public void addRelative(DocumentType documentType, String id, Collection<String> relativeIds) {
        if (relativeIds == null || relativeIds.isEmpty()) {
            return;
        }
        String[] data = relativeIds.toArray(new String[relativeIds.size()]);
        if (this.getPipeline() != null) {
            this.getPipeline().sadd(CacheTableConstant.getRedisHashKey(documentType, id), data);
        } else {
            this.getSelectedJedisWriter().sadd(CacheTableConstant.getRedisHashKey(documentType, id), data);
        }
    }

    @Override
    public void removeRelative(DocumentType documentType, String id, Collection<String> relativeIds) {
        if (relativeIds == null || relativeIds.isEmpty()) {
            return;
        }
        String[] data = relativeIds.toArray(new String[relativeIds.size()]);
        if (this.getPipeline() != null) {
            this.getPipeline().srem(CacheTableConstant.getRedisHashKey(documentType, id), data);
        } else {
            this.getSelectedJedisWriter().srem(CacheTableConstant.getRedisHashKey(documentType, id), data);
        }
    }

    @Override
    public void close() {
    }

    private void executeMulti() {
        if (this.getPipeline() != null) {
            List rt = this.getPipeline().syncAndReturnAll();
            System.err.println(rt);
        }
    }

    @Override
    public Map<String, String> getDocument(DocumentType documentType, String id) {
        try (Jedis jedis = JedisPoolFactory.getNewJedisResource(this.redisConfig);){
            Map map = jedis.hgetAll(CacheTableConstant.getRedisHashKey(documentType, id));
            return map;
        }
    }

    @Override
    public Map<String, String> getDocumentFromCache(DocumentType documentType, String id, DockMapDbExtractor dbExtractor) {
        return this.getDocumentFromCache(documentType, id, dbExtractor, 7200);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void expireCache(DocumentType documentType, String id) {
        String documentKey;
        block22: {
            documentKey = CacheProviderImpl.getCacheKey(documentType, id);
            try (Jedis jedis = JedisPoolFactory.getNewJedisResource(this.redisConfig);){
                if (documentType == DocumentType.Station_Employee_Set) {
                    Set stationEmployeeIds = null;
                    try (Jedis jedisReader = JedisPoolFactory.getNewJedisResource(this.redisConfig);){
                        stationEmployeeIds = jedisReader.smembers(CacheProviderImpl.getCacheKey(DocumentType.Station_Employee_Set, id));
                    }
                    if (stationEmployeeIds == null || stationEmployeeIds.isEmpty()) break block22;
                    String[] stationEmployeeIdKeys = (String[])stationEmployeeIds.stream().map(ix -> CacheProviderImpl.getCacheKey(DocumentType.Employee_Selected_Security_Station, ix)).toArray(String[]::new);
                    try (Pipeline pipeline = jedis.pipelined();){
                        pipeline.del(stationEmployeeIdKeys);
                        pipeline.syncAndReturnAll();
                        break block22;
                    }
                }
                jedis.del(documentKey);
            }
            catch (Throwable throwable) {
                logger.info("\u6e05\u9664 redis:{}={}:{}", new Object[]{this.redisConfig.getHost(), this.redisConfig.getPort(), documentKey});
                throw throwable;
            }
        }
        logger.info("\u6e05\u9664 redis:{}={}:{}", new Object[]{this.redisConfig.getHost(), this.redisConfig.getPort(), documentKey});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Map<String, String> getDocumentFromCache(DocumentType documentType, String id, DockMapDbExtractor dbExtractor, int cacheInMinutes) {
        if (StringUtils.isEmpty((CharSequence)id)) {
            return Collections.EMPTY_MAP;
        }
        String documentKey = CacheProviderImpl.getCacheKey(documentType, id);
        Map<String, String> value = null;
        try (Jedis jedis = JedisPoolFactory.getNewJedisResource(this.redisConfig);){
            value = jedis.hgetAll(documentKey);
            if (value != null && !value.isEmpty()) return value;
            Class<CacheProviderImpl> clazz = CacheProviderImpl.class;
            synchronized (CacheProviderImpl.class) {
                if (value != null && !value.isEmpty()) return value;
                value = dbExtractor.extract(documentType, id);
                if (value == null || value.isEmpty()) {
                    value.put("empty", "empty");
                }
                try (Pipeline pipeline = jedis.pipelined();){
                    String stationId;
                    pipeline.hset(documentKey, value);
                    if (cacheInMinutes < 0) {
                        cacheInMinutes = 60;
                    }
                    if (documentType == DocumentType.Employee_Selected_Security_Station && (stationId = value.get("ATTENDANCESITEID")) != null && !stationId.isEmpty()) {
                        String stationEmployeeIdsKey = CacheProviderImpl.getCacheKey(DocumentType.Station_Employee_Set, stationId);
                        HashSet<String> stationEmployeeIds = null;
                        try (Jedis jedisReader = JedisPoolFactory.getNewJedisResource(this.redisConfig);){
                            stationEmployeeIds = jedisReader.smembers(stationEmployeeIdsKey);
                            if (stationEmployeeIds == null || stationEmployeeIds.isEmpty()) {
                                stationEmployeeIds = new HashSet<String>();
                            }
                            stationEmployeeIds.add(id);
                        }
                        String[] stationEmployeeIdArray = (String[])stationEmployeeIds.stream().toArray(String[]::new);
                        pipeline.sadd(stationEmployeeIdsKey, stationEmployeeIdArray);
                        pipeline.expire(stationEmployeeIdsKey, (long)(cacheInMinutes * 60));
                    }
                    pipeline.expire(documentKey, (long)(cacheInMinutes * 60));
                    pipeline.sync();
                }
                logger.info("\u6dfb\u52a0 redis:{}={}:{}", new Object[]{this.redisConfig.getHost(), this.redisConfig.getPort(), documentKey});
                // ** MonitorExit[var8_9] (shouldn't be in output)
                return value;
            }
        }
        catch (Exception ex) {
            value = dbExtractor.extract(documentType, id);
            logger.error("v2.redis\u4fe1\u606f\u83b7\u53d6\u5f02\u5e38(\u4ecedb\u8fdb\u884c\u83b7\u53d6):sql={};id={};ex={}", new Object[]{documentType.getFetchSql(), id, ex});
        }
        return value;
    }

    @Override
    public void expireCache(Collection<DocumentExpiredDTO> documents) {
        if (documents == null || documents.isEmpty()) {
            return;
        }
        Collection documentKeys = documents.stream().map(ii -> CacheProviderImpl.getCacheKey(ii.getDocumentType(), ii.getId())).collect(Collectors.toList());
        try (Jedis jedis = JedisPoolFactory.getNewJedisResource(this.redisConfig);){
            jedis.del(documentKeys.toArray(new String[documentKeys.size()]));
        }
    }

    private static String getCacheKey(DocumentType documentType, String id) {
        String documentKey = String.format("dt:%s:%s", documentType, id);
        return documentKey;
    }

    @Override
    public long getSetSize(DocumentType documentType, String id) {
        try (Jedis jedis = JedisPoolFactory.getNewJedisResource(this.redisConfig);){
            long l = jedis.scard(CacheTableConstant.getRedisSetKey(documentType, id));
            return l;
        }
    }

    @Override
    public Set<String> getSet(DocumentType documentType, String id) {
        try (Jedis jedis = JedisPoolFactory.getNewJedisResource(this.redisConfig);){
            Set set = jedis.smembers(CacheTableConstant.getRedisSetKey(documentType, id));
            return set;
        }
    }
}

