/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.event.job.core.domain;

import com.bcxin.event.core.exceptions.BadEventException;
import com.bcxin.event.core.utils.DebeziumUtil;
import com.bcxin.event.job.core.domain.CacheProvider;
import com.bcxin.event.job.core.domain.documents.enums.DocumentType;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class CacheDataProcessor {
    private static final String NUM_OF_SECURITY_MEN = "numofsecuritymen";
    private static final String NUM_OF_SECURITY_STATIONS = "numofsecuritystation";
    private static final String DEPARTMENT_NAME = "departname";
    private static final String ID_CARD_NUMBER = "id_card.number";
    private static final String ID_CARD_TYPE = "id_card.type";
    private static final String ID_CARD_FRONT_PHOTO = "id_card.front_photo";
    private static final String ID_CARD_HEAD_PHOTO = "id_card.head_photo";
    private static final String ID_CARD_REVERSE_PHOTO = "id_card.reverse_photo";
    private static final String ID_CARD_VALID_DATE_FROM = "id_card.valid_date_from";
    private static final String ID_CARD_VALID_DATE_TO = "id_card.valid_date_to";
    private static final String ID_CARD_ADDRESS = "id_card.address";

    public static void processEmployeeData(CacheProvider cacheProvider, Map<String, String> before, Map<String, String> content, DocumentType documentType, String idValue) {
        Map<String, String> departmentMap;
        if (documentType != DocumentType.Employee) {
            return;
        }
        String beforeStatus = DebeziumUtil.getMapValue(before, (String)"status");
        String afterStatus = DebeziumUtil.getMapValue(content, (String)"status");
        String afterOrganizationId = DebeziumUtil.getMapValue(content, (String)"organization_id");
        if ("1".equalsIgnoreCase(afterStatus) && (beforeStatus != null && "0".equalsIgnoreCase(beforeStatus) || StringUtils.isEmpty((CharSequence)beforeStatus))) {
            CacheDataProcessor.refreshEmployee_Station_OrganizationSetAndNumber(cacheProvider, afterOrganizationId, idValue, true);
        } else if ("0".equalsIgnoreCase(afterStatus) && (beforeStatus == null || "1".equalsIgnoreCase(beforeStatus))) {
            CacheDataProcessor.refreshEmployee_Station_OrganizationSetAndNumber(cacheProvider, afterOrganizationId, idValue, false);
        }
        String beforeDepartmentId = DebeziumUtil.getMapValue(before, (String)"department_id");
        String departmentId = DebeziumUtil.getMapValue(content, (String)"department_id");
        if (!StringUtils.equals((CharSequence)beforeDepartmentId, (CharSequence)departmentId) && (departmentMap = cacheProvider.getDocument(DocumentType.Department, departmentId)) != null) {
            cacheProvider.update(DocumentType.Employee, idValue, Collections.singletonMap(DEPARTMENT_NAME, DebeziumUtil.getMapValue(departmentMap, (String)"name")));
        }
    }

    public static void processSecurityStation(CacheProvider cacheProvider, Map<String, String> before, Map<String, String> content, DocumentType documentType, String idValue, String domainIdValue) {
        if (documentType == DocumentType.SecurityStation) {
            boolean hasChanged = false;
            if (!CacheDataProcessor.checkIfValidSecurityStation(content) && CacheDataProcessor.checkIfValidSecurityStation(before)) {
                cacheProvider.removeRelative(DocumentType.Organization_Station_Set, domainIdValue, Collections.singleton(idValue));
                Set<String> stationEmployeeIds = cacheProvider.getSet(DocumentType.Station_Employee_Set, idValue);
                if (stationEmployeeIds != null) {
                    stationEmployeeIds.forEach(emId -> CacheDataProcessor.refreshEmployeeStation(cacheProvider, emId));
                }
                hasChanged = true;
            } else if (CacheDataProcessor.checkIfValidSecurityStation(content)) {
                String beforeAttendanceSiteName = DebeziumUtil.getMapValue(before, (String)"ITEM_attendanceSiteName");
                String afterAttendanceSiteName = DebeziumUtil.getMapValue(content, (String)"ITEM_attendanceSiteName");
                if (!CacheDataProcessor.checkIfValidSecurityStation(before) || !StringUtils.equals((CharSequence)beforeAttendanceSiteName, (CharSequence)afterAttendanceSiteName)) {
                    cacheProvider.addRelative(DocumentType.Organization_Station_Set, domainIdValue, Collections.singleton(idValue));
                    Set<String> stationEmployeeIds = cacheProvider.getSet(DocumentType.Station_Employee_Set, idValue);
                    try {
                        if (stationEmployeeIds != null) {
                            stationEmployeeIds.forEach(eid -> cacheProvider.update(DocumentType.Employee, (String)eid, CacheDataProcessor.getUpdatedFieldsForStationMap(content)));
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        throw new BadEventException(ex);
                    }
                }
                hasChanged = true;
            }
            if (hasChanged) {
                long totalStationInOrgan = cacheProvider.getSetSize(DocumentType.Organization_Station_Set, domainIdValue);
                cacheProvider.update(DocumentType.Organization, domainIdValue, Collections.singletonMap(NUM_OF_SECURITY_STATIONS, String.valueOf(totalStationInOrgan)));
            }
        }
    }

    public static void processSecurityStationPerson(CacheProvider cacheProvider, Map<String, String> before, Map<String, String> content, DocumentType documentType, String idValue, String domainIdValue) {
        String beforeSecurityId;
        if (documentType != DocumentType.SecurityStationPerson) {
            return;
        }
        String attendanceSiteId = DebeziumUtil.getMapValue(before, (String)"item_attendancesiteid");
        String securityId = beforeSecurityId = DebeziumUtil.getMapValue(before, (String)"item_securityid");
        String afterSecurityId = DebeziumUtil.getMapValue(content, (String)"item_securityid");
        String afterId = DebeziumUtil.getMapValue(content, (String)"id");
        String beforeId = DebeziumUtil.getMapValue(before, (String)"id");
        if (StringUtils.isEmpty((CharSequence)attendanceSiteId)) {
            attendanceSiteId = DebeziumUtil.getMapValue(content, (String)"item_attendancesiteid");
            securityId = afterSecurityId;
        }
        boolean changedFlag = false;
        if (!StringUtils.isEmpty((CharSequence)beforeId) && StringUtils.isEmpty((CharSequence)afterId)) {
            cacheProvider.removeRelative(DocumentType.Station_Employee_Set, attendanceSiteId, Collections.singleton(securityId));
            cacheProvider.removeRelative(DocumentType.Employee_Station_Set, securityId, Collections.singleton(attendanceSiteId));
            Map<String, String> employeeMap = cacheProvider.getDocument(DocumentType.Employee, securityId);
            if (employeeMap != null && attendanceSiteId.equalsIgnoreCase(DebeziumUtil.getMapValue(employeeMap, (String)"security_station_id"))) {
                CacheDataProcessor.refreshEmployeeStation(cacheProvider, securityId);
            }
            changedFlag = true;
        } else if (StringUtils.isEmpty((CharSequence)beforeId) && !StringUtils.isEmpty((CharSequence)afterId)) {
            Map<String, String> station = cacheProvider.getDocument(DocumentType.SecurityStation, attendanceSiteId);
            if (station != null && CacheDataProcessor.checkIfValidSecurityStation(station)) {
                cacheProvider.update(DocumentType.Employee, securityId, CacheDataProcessor.getUpdatedFieldsForStationMap(station));
                cacheProvider.addRelative(DocumentType.Station_Employee_Set, attendanceSiteId, Collections.singleton(securityId));
            }
            changedFlag = true;
        }
        if (changedFlag) {
            long value = cacheProvider.getSetSize(DocumentType.Station_Employee_Set, attendanceSiteId);
            cacheProvider.update(DocumentType.SecurityStation, attendanceSiteId, Collections.singletonMap(NUM_OF_SECURITY_MEN, String.valueOf(value)));
        }
    }

    public static void processOrganizationSuperviseDepartmentLevelInfo(CacheProvider cacheProvider, Map<String, String> before, Map<String, String> content, DocumentType documentType, String idValue) {
        if (documentType == DocumentType.Organization) {
            String supervise_depart_id = content.get("supervise_depart_id");
            String beforeSupervise_depart_id = null;
            if (before != null) {
                beforeSupervise_depart_id = before.get("supervise_depart_id");
            }
            if (!StringUtils.equals((CharSequence)supervise_depart_id, beforeSupervise_depart_id)) {
                if (StringUtils.isEmpty((CharSequence)supervise_depart_id) || "#".equalsIgnoreCase(supervise_depart_id)) {
                    HashMap<String, String> superViseDepartMap = new HashMap<String, String>();
                    superViseDepartMap.put("supervise_depart_id", "#");
                    superViseDepartMap.put("supervise_depart_name", "#");
                    superViseDepartMap.put("supervise_region_id", "#");
                    cacheProvider.update(DocumentType.Organization, idValue, superViseDepartMap);
                    cacheProvider.removeRelative(DocumentType.SuperviseDepartmentLevel_ORGANIZATION_SET, supervise_depart_id, Collections.singleton(idValue));
                } else {
                    Map<String, String> departLevelMap = cacheProvider.getDocument(DocumentType.SuperviseDepartmentLevel, supervise_depart_id);
                    if (departLevelMap != null) {
                        HashMap<String, String> superViseDepartMap = new HashMap<String, String>();
                        superViseDepartMap.put("supervise_depart_id", supervise_depart_id);
                        superViseDepartMap.put("supervise_depart_name", DebeziumUtil.getMapValue(departLevelMap, (String)"after.item_name"));
                        superViseDepartMap.put("supervise_region_id", DebeziumUtil.getMapValue(departLevelMap, (String)"after.item_regionid"));
                        cacheProvider.update(DocumentType.Organization, idValue, superViseDepartMap);
                    }
                    cacheProvider.addRelative(DocumentType.SuperviseDepartmentLevel_ORGANIZATION_SET, supervise_depart_id, Collections.singleton(idValue));
                }
            }
        }
    }

    private static void refreshEmployeeStation(CacheProvider cacheProvider, String securityId) {
        Set<String> employeeStationIds = cacheProvider.getSet(DocumentType.Employee_Station_Set, securityId);
        if (employeeStationIds != null && !employeeStationIds.isEmpty()) {
            String finalSecurityId = securityId;
            employeeStationIds.forEach(stationId -> {
                Map<String, String> checkingStationMap = cacheProvider.getDocument(DocumentType.SecurityStation, (String)stationId);
                if (checkingStationMap != null && CacheDataProcessor.checkIfValidSecurityStation(checkingStationMap)) {
                    cacheProvider.update(DocumentType.Employee, finalSecurityId, CacheDataProcessor.getUpdatedFieldsForStationMap(checkingStationMap));
                    return;
                }
            });
        } else {
            HashMap<String, String> emptyEmployeeStationMap = new HashMap<String, String>();
            emptyEmployeeStationMap.put("security_station_id", "#");
            emptyEmployeeStationMap.put("security_station_name", "#");
            emptyEmployeeStationMap.put("security_supervise_depart_id", "#");
            emptyEmployeeStationMap.put("security_supervise_depart_name", "#");
        }
    }

    public static void processUserCredentials(CacheProvider cacheProvider, Map<String, String> before, Map<String, String> content, DocumentType documentType, String idValue) {
        if (documentType != DocumentType.User_Credentials) {
            return;
        }
        String tenant_user_id = DebeziumUtil.getMapValue(content, (String)"tenant_user_id");
        String number = DebeziumUtil.getMapValue(content, (String)"number");
        String type = DebeziumUtil.getMapValue(content, (String)"credential_type");
        String front_photo = DebeziumUtil.getMapValue(content, (String)"front_photo");
        String head_photo = DebeziumUtil.getMapValue(content, (String)"head_photo");
        String reverse_photo = DebeziumUtil.getMapValue(content, (String)"reverse_photo");
        String valid_date_from = DebeziumUtil.getMapValue(content, (String)"valid_date_from");
        String valid_date_to = DebeziumUtil.getMapValue(content, (String)"valid_date_to");
        String address = DebeziumUtil.getMapValue(content, (String)"address");
        String selected = DebeziumUtil.getMapValue(content, (String)"selected");
        HashMap<String, String> data = new HashMap<String, String>();
        if ("1".equalsIgnoreCase(selected)) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            data.put(ID_CARD_NUMBER, number);
            data.put(ID_CARD_TYPE, type);
            data.put(ID_CARD_FRONT_PHOTO, front_photo);
            data.put(ID_CARD_ADDRESS, address);
            data.put(ID_CARD_REVERSE_PHOTO, reverse_photo);
            data.put(ID_CARD_VALID_DATE_FROM, valid_date_from);
            data.put(ID_CARD_VALID_DATE_TO, valid_date_to);
            data.put(ID_CARD_HEAD_PHOTO, head_photo);
            cacheProvider.update(DocumentType.User, tenant_user_id, data);
        }
    }

    private static void refreshEmployee_Station_OrganizationSetAndNumber(CacheProvider cacheProvider, String domainId, String employeeId, boolean isLeave) {
        Set<String> data = cacheProvider.getSet(DocumentType.Employee_Station_Set, employeeId);
        if (data != null) {
            data.forEach(stationId -> {
                if (isLeave) {
                    cacheProvider.removeRelative(DocumentType.Station_Employee_Set, (String)stationId, (Collection<String>)Collections.singleton(employeeId));
                } else {
                    cacheProvider.addRelative(DocumentType.Station_Employee_Set, (String)stationId, (Collection<String>)Collections.singleton(employeeId));
                }
                long totalEmployeeInStation = cacheProvider.getSetSize(DocumentType.Station_Employee_Set, (String)stationId);
                cacheProvider.update(DocumentType.SecurityStation, (String)stationId, Collections.singletonMap(NUM_OF_SECURITY_MEN, String.valueOf(totalEmployeeInStation)));
            });
        }
        if (isLeave) {
            cacheProvider.removeRelative(DocumentType.Organization_Employee_Set, domainId, Collections.singleton(employeeId));
        } else {
            cacheProvider.addRelative(DocumentType.Organization_Employee_Set, domainId, Collections.singleton(employeeId));
        }
        long totalEmployeeInOrganization = cacheProvider.getSetSize(DocumentType.Organization_Employee_Set, domainId);
        cacheProvider.update(DocumentType.Organization, domainId, Collections.singletonMap(NUM_OF_SECURITY_MEN, String.valueOf(totalEmployeeInOrganization)));
    }

    private static boolean checkIfValidSecurityStation(Map<String, String> flagData) {
        if (flagData == null) {
            return false;
        }
        return "\u751f\u6548".equalsIgnoreCase(flagData.get("item_attendancesitestate"));
    }

    private static Map<String, String> getUpdatedFieldsForStationMap(Map<String, String> station) {
        if (station == null || station.isEmpty()) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("security_station_id", DebeziumUtil.getMapValue(station, (String)"id"));
        map.put("security_station_name", DebeziumUtil.getMapValue(station, (String)"item_attendancesitename"));
        map.put("security_supervise_depart_id", DebeziumUtil.getMapValue(station, (String)"item_officepoliceaddressid"));
        map.put("security_supervise_depart_name", DebeziumUtil.getMapValue(station, (String)"item_officepoliceaddress"));
        return map;
    }
}

