/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.event.job.domain.repository.impls;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bcxin.event.core.EntityCollection;
import com.bcxin.event.core.exceptions.ConflictEventException;
import com.bcxin.event.core.exceptions.NoFoundEventException;
import com.bcxin.event.job.domain.entities.JobEntity;
import com.bcxin.event.job.domain.repositories.JobRepository;
import com.bcxin.event.job.domain.repositories.criterias.JobMetaCriteria;
import com.bcxin.event.job.domain.repository.mapper.JobMapper;
import java.util.Collection;
import org.springframework.stereotype.Repository;
import org.springframework.util.StringUtils;

@Repository
public class JobRepositoryImpl
implements JobRepository {
    private final JobMapper jobMapper;

    public JobRepositoryImpl(JobMapper jobMapper) {
        this.jobMapper = jobMapper;
    }

    public void create(JobEntity entity) {
        try {
            this.jobMapper.insert(entity);
        }
        catch (Exception ex) {
            if (ex.toString().contains("unique_job_name")) {
                throw new ConflictEventException("\u8be5\u540d\u79f0\u7684Job\u5df2\u7ecf\u5b58\u5728");
            }
            ex.printStackTrace();
            throw ex;
        }
    }

    public void update(JobEntity entity) {
        try {
            this.jobMapper.updateById(entity);
        }
        catch (Exception ex) {
            if (ex.toString().contains("unique_job_name")) {
                throw new ConflictEventException("\u8be5\u540d\u79f0\u7684Job\u5df2\u7ecf\u5b58\u5728");
            }
            ex.printStackTrace();
            throw ex;
        }
    }

    public void delete(Integer id) {
        int count = this.jobMapper.deleteById(id);
        if (count == 0) {
            throw new NoFoundEventException(String.format("\u627e\u4e0d\u5230\u8be5\u6570\u636e(%s)", id));
        }
    }

    public JobEntity getById(Integer id) {
        return (JobEntity)this.jobMapper.selectById(id);
    }

    public Collection<JobEntity> findAll() {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(JobEntity::isOnline, (Object)true);
        return this.jobMapper.selectList((Wrapper)queryWrapper);
    }

    public JobEntity findByName(String name) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(JobEntity::getName, (Object)name);
        return (JobEntity)this.jobMapper.selectOne((Wrapper)queryWrapper);
    }

    public EntityCollection<JobEntity> search(JobMetaCriteria criteria) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(JobEntity::isDeleted, (Object)false);
        if (StringUtils.hasLength((String)criteria.getKeyword())) {
            queryWrapper.and(ic -> ((LambdaQueryWrapper)((LambdaQueryWrapper)ic.or(cc -> cc.like(JobEntity::getTitle, (Object)criteria.getKeyword()))).or(ix -> ix.like(JobEntity::getDescription, (Object)criteria.getKeyword()))).or(ix -> ix.like(JobEntity::getName, (Object)criteria.getKeyword())));
        }
        Page page = new Page((long)criteria.getPageIndex(), (long)criteria.getPageSize());
        IPage data = this.jobMapper.selectPage((IPage)page, (Wrapper)queryWrapper);
        return EntityCollection.create((Collection)data.getRecords(), (int)criteria.getPageSize(), (Long)data.getTotal());
    }
}

