/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.flink.streaming.cores;

import com.bcxin.flink.streaming.cores.CoreJobContext;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.api.common.restartstrategy.RestartStrategies;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.configuration.TaskManagerOptions;
import org.apache.flink.streaming.api.CheckpointingMode;
import org.apache.flink.streaming.api.environment.CheckpointConfig;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamingCoreEnvironments {
    private static final Logger logger = LoggerFactory.getLogger(StreamingCoreEnvironments.class);

    public static StreamExecutionEnvironment getStreamExecutionEnvironment(CoreJobContext jobContext, boolean enableCheckPoint) {
        logger.info("\u5f00\u59cb\u83b7\u53d6getStreamExecutionEnvironment\u5bf9\u8c61:SavepointPath={};CheckpointPath={}", (Object)jobContext.getConfigProperty().getSavepointPath(), (Object)jobContext.getConfigProperty().getCheckpointPath());
        Configuration configuration = new Configuration();
        Map<String, String> flinkConfig = jobContext.getFlinkConfig();
        StringBuilder params = new StringBuilder();
        if (flinkConfig != null) {
            if (flinkConfig.containsKey(TaskManagerOptions.NETWORK_MEMORY_MIN.key())) {
                String networkMin = flinkConfig.get(TaskManagerOptions.NETWORK_MEMORY_MIN.key());
                configuration.set(TaskManagerOptions.NETWORK_MEMORY_MIN, (Object)MemorySize.parse((String)networkMin));
                params.append(String.format("taskmanager.memory.network.min=%s;", networkMin));
            }
            if (flinkConfig.containsKey(TaskManagerOptions.NETWORK_MEMORY_MAX.key())) {
                String networkMax = flinkConfig.get(TaskManagerOptions.NETWORK_MEMORY_MAX.key());
                configuration.set(TaskManagerOptions.NETWORK_MEMORY_MAX, (Object)MemorySize.parse((String)networkMax));
                params.append(String.format("taskmanager.memory.network.max=%s;", networkMax));
            }
        } else {
            configuration.set(TaskManagerOptions.NETWORK_MEMORY_MIN, (Object)MemorySize.parse((String)"356m"));
            configuration.set(TaskManagerOptions.NETWORK_MEMORY_MAX, (Object)MemorySize.parse((String)"356m"));
            params.append("\u8bbe\u7f6e\u9ed8\u8ba4\u503c:=356m");
        }
        logger.error("(\u65e0\u914d\u7f6eNETWORK-\u542f\u7528v2.Checkpoint={}), \u4f20\u9012\u7684flink\u53c2\u6570\u4fe1\u606f:{};TaskManagerOptions.NETWORK_MEMORY_MAX={}", new Object[]{enableCheckPoint, params, ((MemorySize)configuration.get(TaskManagerOptions.NETWORK_MEMORY_MAX)).getMebiBytes()});
        configuration = new Configuration();
        if (enableCheckPoint) {
            if (!StringUtils.isEmpty((CharSequence)jobContext.getConfigProperty().getSavepointPath())) {
                configuration.setString("execution.savepoint.path", jobContext.getConfigProperty().getSavepointPath());
            }
            StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment((Configuration)configuration);
            env.setRestartStrategy(RestartStrategies.fixedDelayRestart((int)10000, (Time)Time.of((long)5L, (TimeUnit)TimeUnit.SECONDS)));
            env.enableCheckpointing(100L, CheckpointingMode.EXACTLY_ONCE);
            CheckpointConfig checkpointConfig = env.getCheckpointConfig();
            checkpointConfig.setCheckpointStorage(jobContext.getConfigProperty().getCheckpointPath());
            checkpointConfig.setCheckpointingMode(CheckpointingMode.EXACTLY_ONCE);
            checkpointConfig.setMaxConcurrentCheckpoints(2);
            return env;
        }
        StreamExecutionEnvironment tableEnv = StreamExecutionEnvironment.getExecutionEnvironment((Configuration)configuration);
        tableEnv.setRestartStrategy(RestartStrategies.fixedDelayRestart((int)10000, (Time)Time.of((long)5L, (TimeUnit)TimeUnit.SECONDS)));
        return tableEnv;
    }
}

