/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.event.job.core.domain;

import com.bcxin.event.job.core.domain.documents.enums.DocumentType;

public class CacheTableConstant {
    public static final String TENANT_ORGANIZATION = "TENANT_ORGANIZATION";
    public static final String TENANT_USER = "TENANT_USER";
    public static final String TENANT_DEPARTMENT = "TENANT_DEPARTMENT";
    public static final String REDIS_LAST_SYNC_KEY = "flink:";

    public static String getRedisHashKey(DocumentType documentType, String id) {
        return String.format("%s:%s:%s", CacheTableConstant.getRedisPrefix(), documentType, id).toLowerCase();
    }

    public static String getRedisSetKey(DocumentType documentType, String id) {
        return String.format("set:%s", CacheTableConstant.getRedisHashKey(documentType, id));
    }

    public static String getSyncKey(DocumentType documentType) {
        return String.format("%s:sync:ts_version:%s", CacheTableConstant.getRedisPrefix(), documentType);
    }

    public static String getSyncDescKey() {
        return String.format("%s:sync:description", CacheTableConstant.getRedisPrefix());
    }

    private static String getRedisPrefix() {
        return "flink:cdc";
    }
}

