/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.util;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.zbkj.common.constants.OnePassConstants;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.utils.RedisUtil;
import com.zbkj.common.utils.RestTemplateUtil;
import com.zbkj.common.vo.OnePassApplicationInfoVo;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

@Component
public class OnePassUtil {
    @Autowired
    private RestTemplateUtil restTemplateUtil;
    @Autowired
    private RedisUtil redisUtil;

    public String getToken(OnePassApplicationInfoVo infoVo) {
        boolean exists = this.redisUtil.exists(StrUtil.format((CharSequence)"one_pass_token_{}", (Object[])new Object[]{infoVo.getAccessKey()}));
        if (exists) {
            Object token = this.redisUtil.get(StrUtil.format((CharSequence)"one_pass_token_{}", (Object[])new Object[]{infoVo.getAccessKey()}));
            return token.toString();
        }
        LinkedMultiValueMap map = new LinkedMultiValueMap();
        map.add((Object)"access_key", (Object)infoVo.getAccessKey());
        map.add((Object)"secret_key", (Object)infoVo.getSecretKey());
        JSONObject jsonObject = this.postFrom("https://sms.crmeb.net/api/v2/user/login", (MultiValueMap<String, Object>)map, null);
        String accessToken = "Bearer-".concat(jsonObject.getJSONObject("data").getString("access_token"));
        this.redisUtil.set(StrUtil.format((CharSequence)"one_pass_token_{}", (Object[])new Object[]{infoVo.getAccessKey()}), (Object)accessToken, Long.valueOf(600L), TimeUnit.SECONDS);
        return accessToken;
    }

    public JSONObject postFrom(String url, MultiValueMap<String, Object> param, Map<String, String> header) {
        String result = this.restTemplateUtil.postFromUrlencoded(url, param, header);
        return this.checkResult(result);
    }

    public JSONObject getFrom(String url, MultiValueMap<String, Object> param, Map<String, String> header) {
        JSONObject jsonObject = this.restTemplateUtil.getDataForm(url, param, header);
        return this.checkResult(jsonObject);
    }

    private JSONObject checkResult(String result) {
        if (StringUtils.isBlank((CharSequence)result)) {
            throw new CrmebException("\u4e00\u53f7\u901a\u5e73\u53f0\u63a5\u53e3\u5f02\u5e38\uff0c\u6ca1\u4efb\u4f55\u6570\u636e\u8fd4\u56de\uff01");
        }
        JSONObject jsonObject = null;
        try {
            jsonObject = JSONObject.parseObject((String)result);
        }
        catch (Exception e) {
            throw new CrmebException("\u4e00\u53f7\u901a\u5e73\u53f0\u63a5\u53e3\u5f02\u5e38\uff01");
        }
        if (OnePassConstants.ONE_PASS_ERROR_CODE.equals(jsonObject.getInteger("status"))) {
            throw new CrmebException("\u4e00\u53f7\u901a\u5e73\u53f0\u63a5\u53e3" + jsonObject.getString("msg"));
        }
        return jsonObject;
    }

    private JSONObject checkResult(JSONObject jsonObject) {
        if (ObjectUtil.isNull((Object)jsonObject)) {
            throw new CrmebException("\u4e00\u53f7\u901a\u5e73\u53f0\u63a5\u53e3\u5f02\u5e38\uff0c\u6ca1\u4efb\u4f55\u6570\u636e\u8fd4\u56de\uff01");
        }
        if (OnePassConstants.ONE_PASS_ERROR_CODE.equals(jsonObject.getInteger("status"))) {
            throw new CrmebException("\u4e00\u53f7\u901a\u5e73\u53f0\u63a5\u53e3" + jsonObject.getString("msg"));
        }
        return jsonObject;
    }

    public HashMap<String, String> getCommonHeader(String accessToken) {
        HashMap header = CollUtil.newHashMap();
        header.put("Authorization", accessToken);
        return header;
    }
}

