/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.zbkj.common.constants.BalanceRecordConstants;
import com.zbkj.common.model.user.UserBalanceRecord;
import com.zbkj.common.page.CommonPage;
import com.zbkj.common.request.PageParamRequest;
import com.zbkj.common.request.UserRecordSearchRequest;
import com.zbkj.service.dao.UserBalanceRecordDao;
import com.zbkj.service.service.UserBalanceRecordService;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class UserBalanceRecordServiceImpl
extends ServiceImpl<UserBalanceRecordDao, UserBalanceRecord>
implements UserBalanceRecordService {
    @Resource
    private UserBalanceRecordDao dao;

    @Override
    public List<UserBalanceRecord> getMonetaryRecordByUid(Integer uid) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(UserBalanceRecord::getUid, (Object)uid);
        lqw.eq(UserBalanceRecord::getLinkType, (Object)"order");
        lqw.eq(UserBalanceRecord::getType, (Object)BalanceRecordConstants.BALANCE_RECORD_TYPE_SUB);
        lqw.orderByDesc(UserBalanceRecord::getId);
        return this.dao.selectList((Wrapper)lqw);
    }

    @Override
    public List<UserBalanceRecord> getRechargeRecordByUid(Integer uid) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(UserBalanceRecord::getUid, (Object)uid);
        lqw.eq(UserBalanceRecord::getLinkType, (Object)"recharge");
        lqw.eq(UserBalanceRecord::getType, (Object)BalanceRecordConstants.BALANCE_RECORD_TYPE_ADD);
        lqw.orderByDesc(UserBalanceRecord::getId);
        return this.dao.selectList((Wrapper)lqw);
    }

    @Override
    public PageInfo<UserBalanceRecord> getUserBalanceRecord(Integer uid, String recordType, PageParamRequest pageRequest) {
        return this.commonUserBalanceRecord(uid, recordType, pageRequest.getPage(), pageRequest.getLimit());
    }

    @Override
    public PageInfo<UserBalanceRecord> getAdminUserBalanceRecord(UserRecordSearchRequest request) {
        return this.commonUserBalanceRecord(request.getUserId(), "all", request.getPage(), request.getLimit());
    }

    private PageInfo<UserBalanceRecord> commonUserBalanceRecord(Integer uid, String recordType, Integer pageNum, Integer limitNum) {
        Page page = PageHelper.startPage((int)pageNum, (int)limitNum);
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(UserBalanceRecord::getUid, (Object)uid);
        switch (recordType) {
            case "expenditure": {
                lqw.eq(UserBalanceRecord::getType, (Object)BalanceRecordConstants.BALANCE_RECORD_TYPE_SUB);
                break;
            }
            case "income": {
                lqw.eq(UserBalanceRecord::getType, (Object)BalanceRecordConstants.BALANCE_RECORD_TYPE_ADD);
                break;
            }
            case "recharge": {
                lqw.eq(UserBalanceRecord::getType, (Object)BalanceRecordConstants.BALANCE_RECORD_TYPE_ADD);
                lqw.eq(UserBalanceRecord::getLinkType, (Object)"recharge");
            }
        }
        lqw.orderByDesc(UserBalanceRecord::getId);
        List recordList = this.dao.selectList((Wrapper)lqw);
        return CommonPage.copyPageInfo((Page)page, (List)recordList);
    }
}

