/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.model.admin.SystemAdmin;
import com.zbkj.common.model.system.SystemForm;
import com.zbkj.common.page.CommonPage;
import com.zbkj.common.request.PageParamRequest;
import com.zbkj.common.request.SystemFormAddRequest;
import com.zbkj.common.result.CommonResultCode;
import com.zbkj.common.result.IResultEnum;
import com.zbkj.common.utils.SecurityUtil;
import com.zbkj.common.vo.MyRecord;
import com.zbkj.service.dao.SystemFormDao;
import com.zbkj.service.service.ProductService;
import com.zbkj.service.service.SystemFormService;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.support.TransactionTemplate;

@Service
public class SystemFormServiceImpl
extends ServiceImpl<SystemFormDao, SystemForm>
implements SystemFormService {
    @Resource
    private SystemFormDao dao;
    @Autowired
    private TransactionTemplate transactionTemplate;
    @Autowired
    private ProductService productService;

    @Override
    public PageInfo<SystemForm> getMerchantPage(PageParamRequest pageRequest) {
        SystemAdmin admin = SecurityUtil.getLoginUserVo().getUser();
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.select(new SFunction[]{SystemForm::getId, SystemForm::getFormName, SystemForm::getCreateTime, SystemForm::getUpdateTime});
        lqw.eq(SystemForm::getIsDelete, (Object)0);
        lqw.eq(SystemForm::getMerId, (Object)admin.getMerId());
        lqw.orderByDesc(SystemForm::getId);
        Page page = PageHelper.startPage((int)pageRequest.getPage(), (int)pageRequest.getLimit());
        List list = this.dao.selectList((Wrapper)lqw);
        return CommonPage.copyPageInfo((Page)page, (List)list);
    }

    @Override
    public MyRecord addForm(SystemFormAddRequest request) {
        SystemAdmin admin = SecurityUtil.getLoginUserVo().getUser();
        SystemForm systemForm = new SystemForm();
        systemForm.setFormName(request.getFormName());
        systemForm.setAllKeys(StrUtil.isNotBlank((CharSequence)request.getAllKeys()) ? request.getAllKeys() : "");
        if (StrUtil.isNotBlank((CharSequence)request.getFormValue())) {
            systemForm.setFormValue(JSONObject.parseObject((String)request.getFormValue()).toJSONString());
        } else {
            systemForm.setFormValue("");
        }
        systemForm.setMerId(admin.getMerId());
        boolean save = this.save(systemForm);
        if (!save) {
            throw new CrmebException((IResultEnum)CommonResultCode.ERROR, "\u4fdd\u5b58\u7cfb\u7edf\u8868\u5355\u5f02\u5e38");
        }
        MyRecord record = new MyRecord();
        record.set("id", (Object)systemForm.getId());
        return record;
    }

    @Override
    public Boolean updateForm(SystemFormAddRequest request) {
        SystemAdmin admin = SecurityUtil.getLoginUserVo().getUser();
        SystemForm systemForm = this.getByIdAndMerValidator(request.getId(), admin.getMerId());
        systemForm.setFormName(request.getFormName());
        systemForm.setAllKeys(StrUtil.isNotBlank((CharSequence)request.getAllKeys()) ? request.getAllKeys() : "");
        if (StrUtil.isNotBlank((CharSequence)request.getFormValue())) {
            systemForm.setFormValue(JSONObject.parseObject((String)request.getFormValue()).toJSONString());
        } else {
            systemForm.setFormValue("");
        }
        systemForm.setUpdateTime((Date)DateUtil.date());
        return this.updateById(systemForm);
    }

    @Override
    public Boolean deleteForm(Integer id) {
        SystemAdmin admin = SecurityUtil.getLoginUserVo().getUser();
        SystemForm systemForm = this.getByIdAndMerValidator(id, admin.getMerId());
        systemForm.setIsDelete(Boolean.valueOf(true));
        systemForm.setUpdateTime((Date)DateUtil.date());
        return (Boolean)this.transactionTemplate.execute(e -> {
            this.updateById(systemForm);
            this.productService.clearSystemFormByFormId(id);
            return Boolean.TRUE;
        });
    }

    @Override
    public SystemForm getDetail(Integer id) {
        SystemAdmin admin = SecurityUtil.getLoginUserVo().getUser();
        return this.getByIdAndMerValidator(id, admin.getMerId());
    }

    @Override
    public Boolean isExist(Integer id, Integer merId) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.select(new SFunction[]{SystemForm::getId});
        lqw.eq(SystemForm::getId, (Object)id);
        lqw.eq(SystemForm::getMerId, (Object)merId);
        lqw.eq(SystemForm::getIsDelete, (Object)0);
        return this.dao.selectCount((Wrapper)lqw) > 0;
    }

    @Override
    public SystemForm getFrontDetail(Integer id) {
        return this.getByIdException(id);
    }

    private SystemForm getByIdException(Integer id) {
        SystemForm systemForm = (SystemForm)this.getById(id);
        if (ObjectUtil.isNull((Object)systemForm) || systemForm.getIsDelete().booleanValue()) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u7cfb\u7edf\u8868\u5355\u4e0d\u5b58\u5728");
        }
        return systemForm;
    }

    private SystemForm getByIdAndMerValidator(Integer id, Integer merId) {
        SystemForm systemForm = this.getByIdException(id);
        if (!systemForm.getMerId().equals(merId)) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u7cfb\u7edf\u8868\u5355\u4e0d\u5b58\u5728");
        }
        return systemForm;
    }
}

