/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.ReUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.URLUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.zbkj.common.config.CrmebConfig;
import com.zbkj.common.enums.RoleEnum;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.model.admin.SystemAdmin;
import com.zbkj.common.model.admin.SystemRole;
import com.zbkj.common.page.CommonPage;
import com.zbkj.common.request.PageParamRequest;
import com.zbkj.common.request.SystemAdminAddRequest;
import com.zbkj.common.request.SystemAdminRequest;
import com.zbkj.common.request.SystemAdminUpdatePwdRequest;
import com.zbkj.common.request.SystemAdminUpdateRequest;
import com.zbkj.common.response.SystemAdminResponse;
import com.zbkj.common.result.AdminResultCode;
import com.zbkj.common.result.CommonResultCode;
import com.zbkj.common.result.IResultEnum;
import com.zbkj.common.utils.CrmebUtil;
import com.zbkj.common.utils.SecurityUtil;
import com.zbkj.service.dao.SystemAdminDao;
import com.zbkj.service.service.SystemAdminService;
import com.zbkj.service.service.SystemRoleService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.support.TransactionTemplate;

@Service
public class SystemAdminServiceImpl
extends ServiceImpl<SystemAdminDao, SystemAdmin>
implements SystemAdminService {
    @Resource
    private SystemAdminDao dao;
    @Autowired
    private SystemRoleService systemRoleService;
    @Autowired
    private CrmebConfig crmebConfig;
    @Autowired
    private TransactionTemplate transactionTemplate;

    @Override
    public SystemAdmin selectUserByUserNameAndType(String username, Integer type) {
        List<Integer> types = this.addSuperRoleType(type);
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(SystemAdmin::getAccount, (Object)username);
        lqw.in(SystemAdmin::getType, types);
        lqw.eq(SystemAdmin::getIsDel, (Object)false);
        lqw.last(" limit 1");
        return (SystemAdmin)this.dao.selectOne((Wrapper)lqw);
    }

    @Override
    public PageInfo<SystemAdminResponse> getList(SystemAdminRequest request, PageParamRequest pageParamRequest) {
        List systemAdmins;
        Page page = PageHelper.startPage((int)pageParamRequest.getPage(), (int)pageParamRequest.getLimit());
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        if (ObjectUtil.isNotNull((Object)request.getStatus())) {
            lqw.eq(SystemAdmin::getStatus, (Object)request.getStatus());
        }
        if (StrUtil.isNotBlank((CharSequence)request.getRealName())) {
            String decode = URLUtil.decode((String)request.getRealName());
            lqw.and(i -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)i.like(SystemAdmin::getRealName, (Object)decode)).or()).like(SystemAdmin::getAccount, (Object)decode);
            });
        }
        SystemAdmin currentAdmin = SecurityUtil.getLoginUserVo().getUser();
        lqw.eq(SystemAdmin::getMerId, (Object)currentAdmin.getMerId());
        lqw.eq(SystemAdmin::getIsDel, (Object)Boolean.FALSE);
        ArrayList<Integer> types = new ArrayList<Integer>();
        if (currentAdmin.getType().equals(RoleEnum.SUPER_MERCHANT.getValue())) {
            types.add(RoleEnum.MERCHANT_ADMIN.getValue());
            types.add(RoleEnum.SUPER_MERCHANT.getValue());
            lqw.in(SystemAdmin::getType, types);
        } else if (currentAdmin.getType().equals(RoleEnum.SUPER_ADMIN.getValue())) {
            types.add(RoleEnum.PLATFORM_ADMIN.getValue());
            types.add(RoleEnum.SUPER_ADMIN.getValue());
            lqw.in(SystemAdmin::getType, types);
        } else {
            lqw.eq(SystemAdmin::getType, (Object)this.systemRoleService.getRoleTypeByCurrentAdmin());
        }
        if (ObjectUtil.isNotNull((Object)request.getRoles()) && request.getRoles() > 0) {
            lqw.apply(" find_in_set({0}, roles)", new Object[]{request.getRoles()});
        }
        if (CollUtil.isEmpty((Collection)(systemAdmins = this.dao.selectList((Wrapper)lqw)))) {
            return CommonPage.copyPageInfo((Page)page, new ArrayList());
        }
        ArrayList<SystemAdminResponse> adminResponseList = new ArrayList<SystemAdminResponse>();
        List<SystemRole> roleList = this.systemRoleService.getListByMerId(currentAdmin.getMerId());
        for (SystemAdmin admin : systemAdmins) {
            SystemAdminResponse sar = new SystemAdminResponse();
            BeanUtils.copyProperties((Object)admin, (Object)sar);
            sar.setLastTime(admin.getUpdateTime());
            List roleIds = CrmebUtil.stringToArrayInt((String)admin.getRoles());
            ArrayList<String> roleNames = new ArrayList<String>();
            for (Integer roleId : roleIds) {
                if (1 == roleId) {
                    roleNames.add("\u8d85\u7ea7\u7ba1\u7406\u5458");
                    continue;
                }
                if (2 == roleId) {
                    roleNames.add("\u5546\u6237\u8d85\u7ba1");
                    continue;
                }
                for (SystemRole role : roleList) {
                    if (!role.getId().equals(roleId)) continue;
                    roleNames.add(role.getRoleName());
                }
            }
            sar.setRoleNames(StringUtils.join(roleNames, (String)","));
            if (this.crmebConfig.getPhoneMaskSwitch().booleanValue() && StrUtil.isNotBlank((CharSequence)sar.getPhone())) {
                sar.setPhone(CrmebUtil.maskMobile((String)sar.getPhone()));
            }
            adminResponseList.add(sar);
        }
        return CommonPage.copyPageInfo((Page)page, adminResponseList);
    }

    @Override
    public Boolean isExistRole(Integer roleId) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.select(new SFunction[]{SystemAdmin::getId});
        lqw.apply(StrUtil.format((CharSequence)" find_in_set('{}', roles)", (Object[])new Object[]{roleId}), new Object[0]);
        lqw.last(" limit 1");
        SystemAdmin systemAdmin = (SystemAdmin)this.dao.selectOne((Wrapper)lqw);
        return ObjectUtil.isNotNull((Object)systemAdmin);
    }

    @Override
    public Boolean saveAdmin(SystemAdminAddRequest systemAdminAddRequest) {
        SystemAdmin currentUser = SecurityUtil.getLoginUserVo().getUser();
        if (this.checkAccount(systemAdminAddRequest.getAccount()).booleanValue()) {
            throw new CrmebException((IResultEnum)AdminResultCode.ADMIN_EXIST);
        }
        SystemAdmin systemAdmin = new SystemAdmin();
        BeanUtils.copyProperties((Object)systemAdminAddRequest, (Object)systemAdmin);
        String pwd = CrmebUtil.encryptPassword((String)systemAdmin.getPwd(), (String)systemAdmin.getAccount());
        systemAdmin.setPwd(pwd);
        systemAdmin.setMerId(currentUser.getMerId());
        systemAdmin.setType(this.systemRoleService.getRoleTypeByCurrentAdmin());
        return this.save(systemAdmin);
    }

    @Override
    public Boolean checkAccount(String account) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(SystemAdmin::getAccount, (Object)account);
        lqw.eq(SystemAdmin::getIsDel, (Object)false);
        return this.dao.selectCount((Wrapper)lqw) > 0;
    }

    @Override
    public Boolean updateAdmin(SystemAdminUpdateRequest systemAdminRequest) {
        SystemAdmin currentUser = SecurityUtil.getLoginUserVo().getUser();
        SystemAdmin adminDetail = this.getDetail(systemAdminRequest.getId());
        if (adminDetail.getType().equals(RoleEnum.SUPER_ADMIN.getValue()) || adminDetail.getType().equals(RoleEnum.SUPER_MERCHANT.getValue())) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u7cfb\u7edf\u5185\u7f6e\u6743\u9650\uff0c\u4e0d\u5141\u8bb8\u7f16\u8f91");
        }
        if (!currentUser.getMerId().equals(adminDetail.getMerId())) {
            throw new CrmebException((IResultEnum)AdminResultCode.ADMIN_NOT_EXIST);
        }
        this.verifyAccount(systemAdminRequest.getId(), systemAdminRequest.getAccount());
        SystemAdmin systemAdmin = new SystemAdmin();
        systemAdmin.setId(systemAdminRequest.getId());
        systemAdmin.setAccount(systemAdminRequest.getAccount());
        systemAdmin.setRealName(systemAdminRequest.getRealName());
        systemAdmin.setRoles(systemAdminRequest.getRoles());
        systemAdmin.setStatus(systemAdminRequest.getStatus());
        if (StrUtil.isNotBlank((CharSequence)systemAdminRequest.getPhone())) {
            systemAdmin.setPhone(systemAdminRequest.getPhone());
        }
        systemAdmin.setMerId(currentUser.getMerId());
        systemAdmin.setUpdateTime((Date)DateUtil.date());
        return this.updateById(systemAdmin);
    }

    @Override
    public Boolean removeAdmin(Integer id) {
        SystemAdmin perDelAdmin = this.getDetail(id);
        if (perDelAdmin.getType().equals(RoleEnum.SUPER_ADMIN.getValue()) || perDelAdmin.getType().equals(RoleEnum.SUPER_MERCHANT.getValue()) || perDelAdmin.getType().equals(RoleEnum.CIRCLE_SUPER.getValue()) || perDelAdmin.getType().equals(RoleEnum.CIRCLE_SUPER.getValue())) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u7cfb\u7edf\u5185\u7f6e\u6743\u9650\uff0c\u4e0d\u5141\u8bb8\u5220\u9664");
        }
        SystemAdmin admin = SecurityUtil.getLoginUserVo().getUser();
        if (!admin.getMerId().equals(perDelAdmin.getMerId())) {
            throw new CrmebException((IResultEnum)AdminResultCode.ADMIN_NOT_EXIST);
        }
        return this.removeById(id);
    }

    @Override
    public Boolean updateStatus(Integer id, Boolean status) {
        SystemAdmin currentUser = SecurityUtil.getLoginUserVo().getUser();
        SystemAdmin systemAdmin = this.getDetail(id);
        if (systemAdmin.getType().equals(RoleEnum.SUPER_ADMIN.getValue()) || systemAdmin.getType().equals(RoleEnum.SUPER_MERCHANT.getValue()) || systemAdmin.getType().equals(RoleEnum.CIRCLE_SUPER.getValue()) || systemAdmin.getType().equals(RoleEnum.CIRCLE_SUPER.getValue())) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u7cfb\u7edf\u5185\u7f6e\u6743\u9650\uff0c\u4e0d\u5141\u8bb8\u7f16\u8f91");
        }
        if (!currentUser.getMerId().equals(systemAdmin.getMerId())) {
            throw new CrmebException((IResultEnum)AdminResultCode.ADMIN_NOT_EXIST);
        }
        if (systemAdmin.getStatus().equals(status)) {
            return true;
        }
        systemAdmin.setStatus(status);
        systemAdmin.setUpdateTime((Date)DateUtil.date());
        return this.updateById(systemAdmin);
    }

    @Override
    public SystemAdmin getDetail(Integer id) {
        SystemAdmin systemAdmin = (SystemAdmin)this.getById(id);
        if (ObjectUtil.isNull((Object)systemAdmin) || systemAdmin.getIsDel().booleanValue()) {
            throw new CrmebException((IResultEnum)AdminResultCode.ADMIN_NOT_EXIST);
        }
        SystemAdmin admin = SecurityUtil.getLoginUserVo().getUser();
        if (admin.getMerId() > 0 && !admin.getMerId().equals(systemAdmin.getMerId())) {
            throw new CrmebException((IResultEnum)AdminResultCode.ADMIN_NOT_EXIST);
        }
        return systemAdmin;
    }

    @Override
    public Map<Integer, String> getNameMapByIdList(List<Integer> idList) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.select(new SFunction[]{SystemAdmin::getId, SystemAdmin::getRealName});
        lqw.in(SystemAdmin::getId, idList);
        List adminList = this.dao.selectList((Wrapper)lqw);
        HashMap map = CollUtil.newHashMap();
        adminList.forEach(admin -> map.put(admin.getId(), admin.getRealName()));
        return map;
    }

    @Override
    public Boolean updatePassword(SystemAdminUpdatePwdRequest request) {
        if (!request.getPassword().equals(request.getConfirmPassword())) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u4e24\u6b21\u5bc6\u7801\u8f93\u5165\u4e0d\u4e00\u81f4");
        }
        SystemAdmin currentUser = SecurityUtil.getLoginUserVo().getUser();
        SystemAdmin adminDetail = this.getDetail(request.getId());
        if (adminDetail.getType().equals(RoleEnum.SUPER_ADMIN.getValue()) || adminDetail.getType().equals(RoleEnum.SUPER_MERCHANT.getValue()) || adminDetail.getType().equals(RoleEnum.CIRCLE_SUPER.getValue()) || adminDetail.getType().equals(RoleEnum.CIRCLE_SUPER.getValue())) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u7cfb\u7edf\u5185\u7f6e\u6743\u9650\uff0c\u4e0d\u5141\u8bb8\u7f16\u8f91");
        }
        if (!currentUser.getMerId().equals(adminDetail.getMerId())) {
            throw new CrmebException((IResultEnum)AdminResultCode.ADMIN_NOT_EXIST);
        }
        SystemAdmin newAdmin = new SystemAdmin();
        newAdmin.setId(request.getId());
        newAdmin.setPwd(CrmebUtil.encryptPassword((String)request.getPassword(), (String)adminDetail.getAccount()));
        newAdmin.setUpdateTime((Date)DateUtil.date());
        return this.updateById(newAdmin);
    }

    @Override
    public Boolean updateReceiveSms(Integer adminId) {
        SystemAdmin admin = SecurityUtil.getLoginUserVo().getUser();
        SystemAdmin systemAdmin = (SystemAdmin)this.getById(adminId);
        if (!admin.getMerId().equals(systemAdmin.getMerId())) {
            throw new CrmebException((IResultEnum)AdminResultCode.ADMIN_NOT_EXIST);
        }
        if (!systemAdmin.getIsSms().booleanValue() && StrUtil.isBlank((CharSequence)systemAdmin.getPhone())) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u8bf7\u5148\u4e3a\u7ba1\u7406\u5458\u8bbe\u7f6e\u624b\u673a\u53f7");
        }
        if (!ReUtil.isMatch((String)"^1\\d{10}$", (CharSequence)systemAdmin.getPhone())) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u8bf7\u5148\u4e3a\u7ba1\u7406\u5458\u8bbe\u7f6e\u624b\u673a\u53f7");
        }
        systemAdmin.setIsSms(Boolean.valueOf(systemAdmin.getIsSms() == false));
        systemAdmin.setUpdateTime((Date)DateUtil.date());
        return this.updateById(systemAdmin);
    }

    @Override
    public List<SystemAdmin> findReceiveSmsAdminListByMerId(Integer merId) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.select(new SFunction[]{SystemAdmin::getId, SystemAdmin::getPhone, SystemAdmin::getRealName});
        lqw.eq(SystemAdmin::getMerId, (Object)merId);
        lqw.eq(SystemAdmin::getIsSms, (Object)1);
        lqw.eq(SystemAdmin::getStatus, (Object)1);
        lqw.eq(SystemAdmin::getIsDel, (Object)0);
        return this.dao.selectList((Wrapper)lqw);
    }

    @Override
    public SystemAdmin getSuperAdminByPlat(Integer merId) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(SystemAdmin::getMerId, (Object)merId);
        lqw.eq(SystemAdmin::getType, (Object)RoleEnum.SUPER_MERCHANT.getValue());
        lqw.eq(SystemAdmin::getIsDel, (Object)false);
        lqw.last(" limit 1");
        return (SystemAdmin)this.dao.selectOne((Wrapper)lqw);
    }

    private void verifyAccount(Integer id, String account) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.ne(SystemAdmin::getId, (Object)id);
        lqw.eq(SystemAdmin::getAccount, (Object)account);
        SystemAdmin systemAdmin = (SystemAdmin)this.dao.selectOne((Wrapper)lqw);
        if (ObjectUtil.isNotNull((Object)systemAdmin)) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u8d26\u53f7\u5df2\u5b58\u5728");
        }
    }

    private List<Integer> addSuperRoleType(Integer type) {
        ArrayList<Integer> types = new ArrayList<Integer>();
        if (type.equals(RoleEnum.PLATFORM_ADMIN.getValue())) {
            types.add(RoleEnum.SUPER_ADMIN.getValue());
            types.add(RoleEnum.PLATFORM_ADMIN.getValue());
        }
        if (type.equals(RoleEnum.MERCHANT_ADMIN.getValue())) {
            types.add(RoleEnum.SUPER_MERCHANT.getValue());
            types.add(RoleEnum.MERCHANT_ADMIN.getValue());
        }
        return types;
    }
}

