/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import com.anji.captcha.model.common.ResponseModel;
import com.anji.captcha.model.vo.CaptchaVO;
import com.anji.captcha.service.CaptchaService;
import com.anji.captcha.util.StringUtils;
import com.zbkj.service.service.SafetyService;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SafetyServiceImpl
implements SafetyService {
    @Autowired
    private CaptchaService captchaService;

    @Override
    public ResponseModel getSafetyCode(CaptchaVO data, HttpServletRequest request) {
        assert (request.getRemoteHost() != null);
        data.setBrowserInfo(SafetyServiceImpl.getRemoteId(request));
        return this.captchaService.get(data);
    }

    @Override
    public ResponseModel checkSafetyCode(CaptchaVO data, HttpServletRequest request) {
        data.setBrowserInfo(SafetyServiceImpl.getRemoteId(request));
        return this.captchaService.check(data);
    }

    @Override
    public ResponseModel verifySafetyCode(CaptchaVO data) {
        return this.captchaService.verification(data);
    }

    public static final String getRemoteId(HttpServletRequest request) {
        String xfwd = request.getHeader("X-Forwarded-For");
        String ip = SafetyServiceImpl.getRemoteIpFromXfwd(xfwd);
        String ua = request.getHeader("user-agent");
        if (StringUtils.isNotBlank((String)ip)) {
            return ip + ua;
        }
        return request.getRemoteAddr() + ua;
    }

    private static String getRemoteIpFromXfwd(String xfwd) {
        if (StringUtils.isNotBlank((String)xfwd)) {
            String[] ipList = xfwd.split(",");
            return StringUtils.trim((String)ipList[0]);
        }
        return null;
    }
}

