/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.model.product.Product;
import com.zbkj.common.model.product.ProductGuarantee;
import com.zbkj.common.request.ProductGuaranteeRequest;
import com.zbkj.common.response.ProductGuaranteeResponse;
import com.zbkj.common.result.CommonResultCode;
import com.zbkj.common.result.IResultEnum;
import com.zbkj.common.result.ProductResultCode;
import com.zbkj.service.dao.ProductGuaranteeDao;
import com.zbkj.service.service.MerchantProductGuaranteeGroupService;
import com.zbkj.service.service.ProductGuaranteeService;
import com.zbkj.service.service.ProductService;
import com.zbkj.service.service.SystemAttachmentService;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.support.TransactionTemplate;

@Service
public class ProductGuaranteeServiceImpl
extends ServiceImpl<ProductGuaranteeDao, ProductGuarantee>
implements ProductGuaranteeService {
    @Resource
    private ProductGuaranteeDao dao;
    @Autowired
    private TransactionTemplate transactionTemplate;
    @Autowired
    private SystemAttachmentService systemAttachmentService;
    @Autowired
    private ProductService productService;
    @Autowired
    private MerchantProductGuaranteeGroupService merchantProductGuaranteeGroupService;

    @Override
    public List<ProductGuaranteeResponse> getAdminList() {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(ProductGuarantee::getIsDel, (Object)false);
        lqw.orderByDesc(ProductGuarantee::getSort);
        List guaranteeList = this.dao.selectList((Wrapper)lqw);
        if (CollUtil.isEmpty((Collection)guaranteeList)) {
            return CollUtil.newArrayList((Object[])new ProductGuaranteeResponse[0]);
        }
        return guaranteeList.stream().map(guarantee -> {
            ProductGuaranteeResponse response = new ProductGuaranteeResponse();
            BeanUtils.copyProperties((Object)guarantee, (Object)response);
            response.setMerNum(Integer.valueOf(0));
            response.setProNum(Integer.valueOf(0));
            List<Product> productList = this.productService.findUseGuarantee(guarantee.getId());
            if (CollUtil.isNotEmpty(productList)) {
                List merList = productList.stream().map(Product::getMerId).distinct().collect(Collectors.toList());
                response.setMerNum(Integer.valueOf(merList.size()));
                response.setProNum(Integer.valueOf(productList.size()));
            }
            return response;
        }).collect(Collectors.toList());
    }

    @Override
    public Boolean add(ProductGuaranteeRequest request) {
        this.validateName(request.getName());
        ProductGuarantee guarantee = new ProductGuarantee();
        BeanUtils.copyProperties((Object)request, (Object)guarantee);
        guarantee.setId(null);
        guarantee.setIcon(this.systemAttachmentService.clearPrefix(guarantee.getIcon()));
        if (ObjectUtil.isNull((Object)request.getIsShow())) {
            guarantee.setIsShow(Boolean.valueOf(true));
        }
        return this.dao.insert(guarantee) > 0;
    }

    @Override
    public Boolean delete(Integer id) {
        ProductGuarantee guarantee = this.getByIdException(id);
        if (this.productService.isUseGuarantee(guarantee.getId()).booleanValue()) {
            throw new CrmebException((IResultEnum)ProductResultCode.PRODUCT_GUARANTEE_USED);
        }
        guarantee.setIsDel(Boolean.valueOf(true));
        guarantee.setUpdateTime((Date)DateUtil.date());
        return (Boolean)this.transactionTemplate.execute(e -> {
            this.updateById(guarantee);
            this.merchantProductGuaranteeGroupService.deleteByGid(guarantee.getId());
            return Boolean.TRUE;
        });
    }

    @Override
    public Boolean edit(ProductGuaranteeRequest request) {
        if (ObjectUtil.isNull((Object)request.getId())) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u4fdd\u969c\u670d\u52a1id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ProductGuarantee oldGuarantee = this.getByIdException(request.getId());
        if (!oldGuarantee.getName().equals(request.getName())) {
            this.validateName(request.getName());
        }
        ProductGuarantee guarantee = new ProductGuarantee();
        BeanUtils.copyProperties((Object)request, (Object)guarantee);
        guarantee.setIcon(this.systemAttachmentService.clearPrefix(request.getIcon()));
        guarantee.setUpdateTime((Date)DateUtil.date());
        return this.updateById(guarantee);
    }

    @Override
    public Boolean updateShowStatus(Integer id) {
        ProductGuarantee guarantee;
        guarantee.setIsShow(Boolean.valueOf((guarantee = this.getByIdException(id)).getIsShow() == false));
        guarantee.setUpdateTime((Date)DateUtil.date());
        return (Boolean)this.transactionTemplate.execute(e -> {
            this.updateById(guarantee);
            this.merchantProductGuaranteeGroupService.updateShowByGid(guarantee.getId(), guarantee.getIsShow());
            return Boolean.TRUE;
        });
    }

    @Override
    public List<ProductGuarantee> getList(Integer type) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(ProductGuarantee::getIsDel, (Object)false);
        if (type.equals(1)) {
            lqw.eq(ProductGuarantee::getIsShow, (Object)true);
        }
        lqw.orderByDesc(ProductGuarantee::getSort);
        return this.dao.selectList((Wrapper)lqw);
    }

    @Override
    public List<ProductGuarantee> findByIdList(List<Integer> idList) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(ProductGuarantee::getIsDel, (Object)false);
        lqw.eq(ProductGuarantee::getIsShow, (Object)true);
        lqw.in(ProductGuarantee::getId, idList);
        return this.dao.selectList((Wrapper)lqw);
    }

    private ProductGuarantee getByIdException(Integer id) {
        ProductGuarantee guarantee = (ProductGuarantee)this.getById(id);
        if (ObjectUtil.isNull((Object)guarantee) || guarantee.getIsDel().booleanValue()) {
            throw new CrmebException((IResultEnum)ProductResultCode.PRODUCT_GUARANTEE_NOT_EXIST);
        }
        return guarantee;
    }

    private void validateName(String name) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.select(new SFunction[]{ProductGuarantee::getId});
        lqw.eq(ProductGuarantee::getName, (Object)name);
        lqw.eq(ProductGuarantee::getIsDel, (Object)false);
        lqw.last("limit 1");
        ProductGuarantee productGuarantee = (ProductGuarantee)this.dao.selectOne((Wrapper)lqw);
        if (ObjectUtil.isNotNull((Object)productGuarantee)) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u4fdd\u969c\u670d\u52a1\u540d\u79f0\u5df2\u5b58\u5728");
        }
    }
}

