/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.zbkj.common.model.bill.PlatformDailyStatement;
import com.zbkj.common.model.order.OrderProfitSharing;
import com.zbkj.common.model.order.RefundOrder;
import com.zbkj.common.page.CommonPage;
import com.zbkj.common.request.PageParamRequest;
import com.zbkj.common.utils.CrmebDateUtil;
import com.zbkj.common.vo.DateLimitUtilVo;
import com.zbkj.service.dao.PlatformDailyStatementDao;
import com.zbkj.service.service.OrderProfitSharingService;
import com.zbkj.service.service.PlatformDailyStatementService;
import com.zbkj.service.service.RechargeOrderService;
import com.zbkj.service.service.RefundOrderService;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PlatformDailyStatementServiceImpl
extends ServiceImpl<PlatformDailyStatementDao, PlatformDailyStatement>
implements PlatformDailyStatementService {
    @Resource
    private PlatformDailyStatementDao dao;
    @Autowired
    private OrderProfitSharingService orderProfitSharingService;
    @Autowired
    private RefundOrderService refundOrderService;
    @Autowired
    private RechargeOrderService rechargeOrderService;

    @Override
    public PlatformDailyStatement getByDate(String date) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(PlatformDailyStatement::getDataDate, (Object)date);
        lqw.last(" limit 1");
        return (PlatformDailyStatement)this.dao.selectOne((Wrapper)lqw);
    }

    @Override
    public List<PlatformDailyStatement> findByMonth(String month) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.apply("date_format(data_date, '%Y-%m') = {0}", new Object[]{month});
        return this.dao.selectList((Wrapper)lqw);
    }

    @Override
    public PageInfo<PlatformDailyStatement> getPageList(String dateLimit, PageParamRequest pageParamRequest) {
        Page page = PageHelper.startPage((int)pageParamRequest.getPage(), (int)pageParamRequest.getLimit());
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        if (StrUtil.isNotEmpty((CharSequence)dateLimit)) {
            DateLimitUtilVo dateLimitVo = CrmebDateUtil.getDateLimit((String)dateLimit);
            String startDate = DateUtil.parse((String)dateLimitVo.getStartTime()).toDateStr();
            String endDate = DateUtil.parse((String)dateLimitVo.getEndTime()).toDateStr();
            lqw.between(PlatformDailyStatement::getDataDate, (Object)startDate, (Object)endDate);
        }
        lqw.orderByDesc(PlatformDailyStatement::getId);
        List list = this.dao.selectList((Wrapper)lqw);
        if (CollUtil.isEmpty((Collection)list)) {
            return CommonPage.copyPageInfo((Page)page, (List)list);
        }
        String today = DateUtil.date().toDateStr();
        for (PlatformDailyStatement dailyStatement : list) {
            if (!dailyStatement.getDataDate().equals(today)) continue;
            this.writeDailyStatement(dailyStatement);
        }
        return CommonPage.copyPageInfo((Page)page, (List)list);
    }

    private void writeDailyStatement(PlatformDailyStatement dailyStatement) {
        List<OrderProfitSharing> sharingList = this.orderProfitSharingService.findByDate(0, dailyStatement.getDataDate());
        List<RefundOrder> refundOrderList = this.refundOrderService.findByDate(0, dailyStatement.getDataDate());
        BigDecimal orderPayAmount = new BigDecimal("0.00");
        int orderPayNum = 0;
        BigDecimal handlingFee = new BigDecimal("0.00");
        BigDecimal merchantTransferAmount = new BigDecimal("0.00");
        int merchantTransferNum = 0;
        BigDecimal refundAmount = new BigDecimal("0.00");
        BigDecimal refundReplaceBrokerage = new BigDecimal("0.00");
        BigDecimal refundReplaceIntegralPrice = new BigDecimal("0.00");
        int refundOrderNum = 0;
        BigDecimal firstBrokerage = new BigDecimal("0.00");
        BigDecimal secondBrokerage = new BigDecimal("0.00");
        BigDecimal integralPrice = new BigDecimal("0.00");
        BigDecimal platCouponPrice = new BigDecimal("0.00");
        BigDecimal brokeragePrice = new BigDecimal("0.00");
        BigDecimal refundPlatCouponPrice = new BigDecimal("0.00");
        BigDecimal refundHandlingFee = new BigDecimal("0.00");
        BigDecimal refundBrokeragePrice = new BigDecimal("0.00");
        BigDecimal refundMerchantTransferAmount = new BigDecimal("0.00");
        BigDecimal freightFee = new BigDecimal("0.00");
        BigDecimal refundFreightFee = new BigDecimal("0.00");
        if (CollUtil.isNotEmpty(sharingList)) {
            orderPayAmount = sharingList.stream().map(OrderProfitSharing::getOrderPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
            orderPayNum = sharingList.size();
            handlingFee = sharingList.stream().map(OrderProfitSharing::getProfitSharingPlatPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
            merchantTransferAmount = sharingList.stream().map(OrderProfitSharing::getProfitSharingMerPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
            firstBrokerage = sharingList.stream().map(OrderProfitSharing::getFirstBrokerageFee).reduce(BigDecimal.ZERO, BigDecimal::add);
            secondBrokerage = sharingList.stream().map(OrderProfitSharing::getSecondBrokerageFee).reduce(BigDecimal.ZERO, BigDecimal::add);
            merchantTransferNum = sharingList.size();
            integralPrice = sharingList.stream().map(OrderProfitSharing::getIntegralPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
            platCouponPrice = sharingList.stream().map(OrderProfitSharing::getPlatCouponPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
            brokeragePrice = firstBrokerage.add(secondBrokerage);
            freightFee = sharingList.stream().map(OrderProfitSharing::getFreightFee).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        if (CollUtil.isNotEmpty(refundOrderList)) {
            refundAmount = refundOrderList.stream().map(RefundOrder::getRefundPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
            refundReplaceBrokerage = refundOrderList.stream().filter(RefundOrder::getIsReplace).map(e -> e.getRefundFirstBrokerageFee().add(e.getRefundSecondBrokerageFee())).reduce(BigDecimal.ZERO, BigDecimal::add);
            refundReplaceIntegralPrice = refundOrderList.stream().map(RefundOrder::getRefundIntegralPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
            refundOrderNum = refundOrderList.size();
            refundPlatCouponPrice = refundOrderList.stream().map(RefundOrder::getRefundPlatCouponPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
            refundHandlingFee = refundOrderList.stream().map(RefundOrder::getPlatformRefundPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
            refundMerchantTransferAmount = refundOrderList.stream().map(RefundOrder::getMerchantRefundPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
            refundBrokeragePrice = refundOrderList.stream().map(e -> e.getRefundFirstBrokerageFee().add(e.getRefundSecondBrokerageFee())).reduce(BigDecimal.ZERO, BigDecimal::add);
            refundFreightFee = refundOrderList.stream().map(RefundOrder::getRefundFreightFee).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        BigDecimal orderIncome = orderPayAmount;
        BigDecimal orderReceivable = orderIncome.add(platCouponPrice).add(integralPrice);
        BigDecimal orderRefundable = refundMerchantTransferAmount.add(refundHandlingFee).add(refundBrokeragePrice);
        BigDecimal orderRefund = refundPlatCouponPrice.add(refundReplaceIntegralPrice).subtract(orderRefundable);
        BigDecimal merchantProfitSharing = merchantTransferAmount.subtract(refundMerchantTransferAmount);
        BigDecimal brokerage = brokeragePrice.subtract(refundBrokeragePrice).add(refundReplaceBrokerage);
        BigDecimal income = orderIncome.add(orderRefund);
        BigDecimal payout = merchantProfitSharing.add(brokerage);
        BigDecimal incomeExpenditure = income.subtract(payout);
        dailyStatement.setOrderPayAmount(orderPayAmount);
        dailyStatement.setTotalOrderNum(Integer.valueOf(orderPayNum));
        dailyStatement.setHandlingFee(handlingFee);
        dailyStatement.setMerchantTransferAmount(merchantTransferAmount);
        dailyStatement.setMerchantTransferNum(Integer.valueOf(merchantTransferNum));
        dailyStatement.setFirstBrokerage(firstBrokerage);
        dailyStatement.setSecondBrokerage(secondBrokerage);
        dailyStatement.setIntegralPrice(integralPrice);
        dailyStatement.setRefundReplaceBrokerage(refundReplaceBrokerage);
        dailyStatement.setRefundReplaceIntegralPrice(refundReplaceIntegralPrice);
        dailyStatement.setRefundAmount(refundAmount);
        dailyStatement.setRefundNum(Integer.valueOf(refundOrderNum));
        dailyStatement.setIncomeExpenditure(incomeExpenditure.abs());
        dailyStatement.setPlatCouponPrice(platCouponPrice);
        dailyStatement.setBrokeragePrice(brokeragePrice);
        dailyStatement.setOrderRefundPrice(refundAmount);
        dailyStatement.setRefundPlatCouponPrice(refundPlatCouponPrice);
        dailyStatement.setRefundHandlingFee(refundHandlingFee);
        dailyStatement.setRefundBrokeragePrice(refundBrokeragePrice);
        dailyStatement.setRefundMerchantTransferAmount(refundMerchantTransferAmount);
        dailyStatement.setFreightFee(freightFee);
        dailyStatement.setRefundFreightFee(refundFreightFee);
    }
}

