/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.URLUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.model.admin.SystemAdmin;
import com.zbkj.common.model.reservation.MerchantServiceStaff;
import com.zbkj.common.model.user.User;
import com.zbkj.common.page.CommonPage;
import com.zbkj.common.request.PageParamRequest;
import com.zbkj.common.request.merchant.MerchantServiceStaffRequest;
import com.zbkj.common.request.merchant.MerchantServiceStaffSearchRequest;
import com.zbkj.common.response.MerchantServiceStaffResponse;
import com.zbkj.common.result.CommonResultCode;
import com.zbkj.common.result.IResultEnum;
import com.zbkj.common.token.FrontTokenComponent;
import com.zbkj.common.utils.SecurityUtil;
import com.zbkj.service.dao.reservation.MerchantServiceStaffDao;
import com.zbkj.service.service.MerchantServiceStaffService;
import com.zbkj.service.service.SystemAttachmentService;
import com.zbkj.service.service.UserService;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MerchantServiceStaffServiceImpl
extends ServiceImpl<MerchantServiceStaffDao, MerchantServiceStaff>
implements MerchantServiceStaffService {
    @Resource
    private MerchantServiceStaffDao dao;
    @Autowired
    private SystemAttachmentService systemAttachmentService;
    @Autowired
    private FrontTokenComponent tokenComponent;
    @Autowired
    private UserService userService;

    @Override
    public PageInfo<MerchantServiceStaffResponse> getList(MerchantServiceStaffSearchRequest request, PageParamRequest pageParamRequest) {
        SystemAdmin systemAdmin = SecurityUtil.getLoginUserVo().getUser();
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        if (ObjectUtil.isNotEmpty((Object)request.getKeywords())) {
            String keywords = URLUtil.decode((String)request.getKeywords());
            wrapper.nested(i -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)i.like(MerchantServiceStaff::getPhone, (Object)keywords)).or()).like(MerchantServiceStaff::getName, (Object)keywords);
            });
        }
        if (ObjectUtil.isNotEmpty((Object)request.getStatus())) {
            wrapper.eq(MerchantServiceStaff::getStatus, (Object)request.getStatus());
        }
        wrapper.eq(MerchantServiceStaff::getIsDelete, (Object)false);
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(MerchantServiceStaff::getMerId, (Object)systemAdmin.getMerId())).orderByDesc(MerchantServiceStaff::getSort)).orderByDesc(MerchantServiceStaff::getCreateTime);
        Page serviceStaffPage = PageHelper.startPage((int)pageParamRequest.getPage(), (int)pageParamRequest.getLimit());
        List staffList = this.dao.selectList((Wrapper)wrapper);
        List responseList = staffList.stream().map(item -> {
            MerchantServiceStaffResponse response = new MerchantServiceStaffResponse();
            BeanUtils.copyProperties((Object)item, (Object)response);
            User user = (User)this.userService.getById(item.getUserId());
            response.setNickName(user.getNickname());
            response.setAvatar(user.getAvatar());
            return response;
        }).collect(Collectors.toList());
        return CommonPage.copyPageInfo((Page)serviceStaffPage, responseList);
    }

    @Override
    public Boolean addMerchantServiceStaff(MerchantServiceStaffRequest request) {
        SystemAdmin systemAdmin = SecurityUtil.getLoginUserVo().getUser();
        this.checkEmployeeExistCurrentMerchant(request);
        MerchantServiceStaff merchantServiceStaff = new MerchantServiceStaff();
        BeanUtils.copyProperties((Object)request, (Object)merchantServiceStaff);
        merchantServiceStaff.setIdPhoto(this.systemAttachmentService.clearPrefix(merchantServiceStaff.getIdPhoto()));
        merchantServiceStaff.setMerId(systemAdmin.getMerId());
        return this.save(merchantServiceStaff);
    }

    @Override
    public Boolean deleteById(Integer id) {
        MerchantServiceStaff serviceStaff = this.checkMerchantServiceStaff(id);
        MerchantServiceStaff updateEntity = new MerchantServiceStaff();
        updateEntity.setId(id);
        updateEntity.setIsDelete(Boolean.valueOf(true));
        updateEntity.setUpdateTime((Date)DateUtil.date());
        boolean success = this.updateById(updateEntity);
        if (success) {
            this.tokenComponent.cleanMerchantUserToken(serviceStaff.getUserId());
        }
        return success;
    }

    @Override
    public Boolean editMerchantServiceStaff(MerchantServiceStaffRequest request) {
        this.checkMerchantServiceStaff(request.getId());
        MerchantServiceStaff merchantServiceStaff = new MerchantServiceStaff();
        BeanUtils.copyProperties((Object)request, (Object)merchantServiceStaff);
        merchantServiceStaff.setIdPhoto(this.systemAttachmentService.clearPrefix(merchantServiceStaff.getIdPhoto()));
        merchantServiceStaff.setUpdateTime((Date)DateUtil.date());
        boolean update = this.updateById(merchantServiceStaff);
        if (update && merchantServiceStaff.getStatus().equals(1) && !request.getStatus().equals(0)) {
            this.tokenComponent.cleanMerchantUserToken(merchantServiceStaff.getUserId());
        }
        return update;
    }

    @Override
    public MerchantServiceStaffResponse getStaffInfo(Integer id) {
        MerchantServiceStaff serviceStaff = (MerchantServiceStaff)this.getById(id);
        if (ObjectUtil.isNull((Object)serviceStaff) || serviceStaff.getIsDelete().booleanValue()) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u6570\u636e\u4e0d\u5b58\u5728");
        }
        MerchantServiceStaffResponse serviceStaffResponse = new MerchantServiceStaffResponse();
        BeanUtils.copyProperties((Object)serviceStaff, (Object)serviceStaffResponse);
        User user = (User)this.userService.getById(serviceStaff.getUserId());
        if (ObjectUtil.isNotNull((Object)user)) {
            serviceStaffResponse.setNickName(user.getNickname());
            serviceStaffResponse.setAvatar(user.getAvatar());
        }
        return serviceStaffResponse;
    }

    @Override
    public Boolean updateStaffStatus(Integer id) {
        MerchantServiceStaff serviceStaff;
        serviceStaff.setStatus(Integer.valueOf((serviceStaff = this.checkMerchantServiceStaff(id)).getStatus() == 1 ? 0 : 1));
        serviceStaff.setUpdateTime((Date)DateUtil.date());
        return this.updateById(serviceStaff);
    }

    private MerchantServiceStaff checkMerchantServiceStaff(Integer id) {
        MerchantServiceStaff serviceStaff = (MerchantServiceStaff)this.getById(id);
        if (ObjectUtil.isNull((Object)serviceStaff) || serviceStaff.getIsDelete().booleanValue()) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u6570\u636e\u4e0d\u5b58\u5728");
        }
        SystemAdmin systemAdmin = SecurityUtil.getLoginUserVo().getUser();
        if (!Objects.equals(serviceStaff.getMerId(), systemAdmin.getMerId())) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u7981\u6b62\u4fee\u6539\u5176\u4ed6\u5546\u6237\u7684\u5458\u5de5");
        }
        return serviceStaff;
    }

    private void checkEmployeeExistCurrentMerchant(MerchantServiceStaffRequest request) {
        LambdaQueryWrapper queryWrapperExit = Wrappers.lambdaQuery();
        queryWrapperExit.eq(MerchantServiceStaff::getUserId, (Object)request.getUserId());
        queryWrapperExit.eq(MerchantServiceStaff::getIsDelete, (Object)false);
        Integer count = this.dao.selectCount((Wrapper)queryWrapperExit);
        if (count > 0) {
            throw new CrmebException("\u5f53\u524d\u7528\u6237\u5df2\u7ecf\u662f\u67d0\u4e2a\u5e97\u94fa\u7684\u670d\u52a1\u5458\u5de5");
        }
    }

    @Override
    public MerchantServiceStaff getByUserId(Integer userId) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(MerchantServiceStaff::getUserId, (Object)userId);
        lqw.eq(MerchantServiceStaff::getIsDelete, (Object)false);
        lqw.last(" limit 1");
        return (MerchantServiceStaff)this.dao.selectOne((Wrapper)lqw);
    }

    @Override
    public List<MerchantServiceStaff> findByMerId(Integer merId) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(MerchantServiceStaff::getMerId, (Object)merId);
        lqw.eq(MerchantServiceStaff::getIsDelete, (Object)false);
        return this.dao.selectList((Wrapper)lqw);
    }

    @Override
    public List<MerchantServiceStaff> findByStaffIdList(List<Integer> staffIdList) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.in(MerchantServiceStaff::getId, staffIdList);
        return this.dao.selectList((Wrapper)lqw);
    }

    @Override
    public List<MerchantServiceStaffResponse> getStaffList(MerchantServiceStaffSearchRequest request, SystemAdmin systemAdmin) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        if (ObjectUtil.isNotEmpty((Object)request.getKeywords())) {
            String keywords = URLUtil.decode((String)request.getKeywords());
            wrapper.nested(i -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)i.like(MerchantServiceStaff::getPhone, (Object)keywords)).or()).like(MerchantServiceStaff::getName, (Object)keywords);
            });
        }
        if (ObjectUtil.isNotEmpty((Object)request.getStatus())) {
            wrapper.eq(MerchantServiceStaff::getStatus, (Object)request.getStatus());
        }
        wrapper.eq(MerchantServiceStaff::getIsDelete, (Object)false);
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(MerchantServiceStaff::getMerId, (Object)systemAdmin.getMerId())).orderByDesc(MerchantServiceStaff::getSort)).orderByDesc(MerchantServiceStaff::getCreateTime);
        List staffList = this.dao.selectList((Wrapper)wrapper);
        return staffList.stream().map(item -> {
            MerchantServiceStaffResponse response = new MerchantServiceStaffResponse();
            BeanUtils.copyProperties((Object)item, (Object)response);
            User user = (User)this.userService.getById(item.getUserId());
            response.setNickName(user.getNickname());
            response.setAvatar(user.getAvatar());
            return response;
        }).collect(Collectors.toList());
    }
}

