/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.model.admin.SystemAdmin;
import com.zbkj.common.model.merchant.MerchantProductCategory;
import com.zbkj.common.request.merchant.MerchantProductCategoryRequest;
import com.zbkj.common.result.CommonResultCode;
import com.zbkj.common.result.IResultEnum;
import com.zbkj.common.result.ProductResultCode;
import com.zbkj.common.utils.RedisUtil;
import com.zbkj.common.utils.SecurityUtil;
import com.zbkj.common.vo.ProCategoryCacheTree;
import com.zbkj.common.vo.ProCategoryCacheVo;
import com.zbkj.service.dao.MerchantProductCategoryDao;
import com.zbkj.service.service.MerchantProductCategoryService;
import com.zbkj.service.service.ProductService;
import com.zbkj.service.service.SystemAttachmentService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.support.TransactionTemplate;

@Service
public class MerchantProductCategoryServiceImpl
extends ServiceImpl<MerchantProductCategoryDao, MerchantProductCategory>
implements MerchantProductCategoryService {
    @Resource
    private MerchantProductCategoryDao dao;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private SystemAttachmentService systemAttachmentService;
    @Autowired
    private ProductService productService;
    @Autowired
    private TransactionTemplate transactionTemplate;

    @Override
    public List<MerchantProductCategory> getAdminList() {
        SystemAdmin admin = SecurityUtil.getLoginUserVo().getUser();
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(MerchantProductCategory::getIsDel, (Object)false);
        lqw.eq(MerchantProductCategory::getMerId, (Object)admin.getMerId());
        lqw.orderByDesc(MerchantProductCategory::getSort);
        lqw.orderByAsc(MerchantProductCategory::getId);
        return this.dao.selectList((Wrapper)lqw);
    }

    @Override
    public Boolean add(MerchantProductCategoryRequest request) {
        boolean save;
        MerchantProductCategory parentCategory;
        SystemAdmin admin = SecurityUtil.getLoginUserVo().getUser();
        if (this.checkName(request.getName(), admin.getMerId()).booleanValue()) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u5206\u7c7b\u540d\u79f0\u5df2\u5b58\u5728");
        }
        if (!request.getPid().equals(0) && !(parentCategory = this.getByIdException(request.getPid())).getPid().equals(0)) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u5546\u6237\u5546\u54c1\u5206\u7c7b\u53ea\u652f\u6301\u4e8c\u7ea7\u5206\u7c7b");
        }
        MerchantProductCategory productCategory = new MerchantProductCategory();
        BeanUtils.copyProperties((Object)request, (Object)productCategory);
        productCategory.setId(null);
        productCategory.setMerId(admin.getMerId());
        if (StrUtil.isNotBlank((CharSequence)productCategory.getIcon())) {
            productCategory.setIcon(this.systemAttachmentService.clearPrefix(productCategory.getIcon()));
        }
        if (save = this.save(productCategory)) {
            this.redisUtil.delete(new String[]{StrUtil.format((CharSequence)"store:product:category:list:{}", (Object[])new Object[]{admin.getMerId()})});
        }
        return save;
    }

    @Override
    public Boolean delete(Integer id) {
        List<MerchantProductCategory> categoryList;
        SystemAdmin admin = SecurityUtil.getLoginUserVo().getUser();
        MerchantProductCategory category = this.getByIdException(id);
        if (!admin.getMerId().equals(category.getMerId())) {
            throw new CrmebException((IResultEnum)ProductResultCode.PRODUCT_MER_CATEGORY_NOT_EXIST);
        }
        if (category.getPid().equals(0) && CollUtil.isNotEmpty(categoryList = this.findAllChildListByPid(id))) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u8be5\u5206\u7c7b\u4e0b\u6709\u5b50\u5206\u7c7b\uff0c\u8bf7\u5148\u5220\u9664\u5b50\u5206\u7c7b");
        }
        if (this.productService.isExistStoreCategory(category.getId()).booleanValue()) {
            throw new CrmebException((IResultEnum)ProductResultCode.PRODUCT_MER_CATEGORY_USED);
        }
        category.setIsDel(Boolean.valueOf(true));
        category.setUpdateTime((Date)DateUtil.date());
        boolean update = this.updateById(category);
        if (update) {
            this.redisUtil.delete(new String[]{StrUtil.format((CharSequence)"store:product:category:list:{}", (Object[])new Object[]{admin.getMerId()})});
        }
        return update;
    }

    @Override
    public Boolean edit(MerchantProductCategoryRequest request) {
        if (ObjectUtil.isNull((Object)request.getId())) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u5546\u54c1\u5206\u7c7bID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SystemAdmin admin = SecurityUtil.getLoginUserVo().getUser();
        MerchantProductCategory oldCategory = this.getByIdException(request.getId());
        if (!admin.getMerId().equals(oldCategory.getMerId())) {
            throw new CrmebException((IResultEnum)ProductResultCode.PRODUCT_MER_CATEGORY_NOT_EXIST);
        }
        if (!oldCategory.getName().equals(request.getName()) && this.checkName(request.getName(), admin.getMerId()).booleanValue()) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u5206\u7c7b\u540d\u79f0\u5df2\u5b58\u5728");
        }
        if (!oldCategory.getPid().equals(0) && request.getPid().equals(0) && this.productService.isExistStoreCategory(oldCategory.getPid()).booleanValue()) {
            throw new CrmebException((IResultEnum)ProductResultCode.PRODUCT_MER_CATEGORY_USED);
        }
        MerchantProductCategory category = new MerchantProductCategory();
        BeanUtils.copyProperties((Object)request, (Object)category);
        if (StrUtil.isNotBlank((CharSequence)category.getIcon())) {
            category.setIcon(this.systemAttachmentService.clearPrefix(category.getIcon()));
        }
        category.setUpdateTime((Date)DateUtil.date());
        boolean update = this.updateById(category);
        if (update) {
            this.redisUtil.delete(new String[]{StrUtil.format((CharSequence)"store:product:category:list:{}", (Object[])new Object[]{admin.getMerId()})});
        }
        return update;
    }

    @Override
    public Boolean updateShowStatus(Integer id) {
        MerchantProductCategory parentCategory;
        boolean showStatus;
        SystemAdmin admin = SecurityUtil.getLoginUserVo().getUser();
        MerchantProductCategory category = this.getByIdException(id);
        if (!admin.getMerId().equals(category.getMerId())) {
            throw new CrmebException((IResultEnum)ProductResultCode.PRODUCT_MER_CATEGORY_NOT_EXIST);
        }
        ArrayList<MerchantProductCategory> categoryList = new ArrayList<MerchantProductCategory>();
        boolean bl = showStatus = category.getIsShow() == false;
        if (!category.getPid().equals(0) && showStatus && !(parentCategory = this.getByIdException(category.getPid())).getIsShow().booleanValue()) {
            parentCategory.setIsShow(Boolean.valueOf(showStatus));
            parentCategory.setUpdateTime((Date)DateUtil.date());
            categoryList.add(parentCategory);
        }
        category.setIsShow(Boolean.valueOf(category.getIsShow() == false));
        category.setUpdateTime((Date)DateUtil.date());
        categoryList.add(category);
        Boolean execute = (Boolean)this.transactionTemplate.execute(e -> {
            this.updateBatchById(categoryList);
            if (category.getPid().equals(0)) {
                this.updateChildShowStatus(category.getId(), showStatus);
            }
            return Boolean.TRUE;
        });
        if (execute.booleanValue()) {
            this.redisUtil.delete(new String[]{StrUtil.format((CharSequence)"store:product:category:list:{}", (Object[])new Object[]{admin.getMerId()})});
        }
        return execute;
    }

    private void updateChildShowStatus(Integer pid, boolean showStatus) {
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
        wrapper.set(MerchantProductCategory::getIsShow, (Object)showStatus);
        wrapper.eq(MerchantProductCategory::getPid, (Object)pid);
        wrapper.eq(MerchantProductCategory::getIsDel, (Object)false);
        this.update((Wrapper)wrapper);
    }

    @Override
    public List<ProCategoryCacheVo> getCacheTree() {
        SystemAdmin admin = SecurityUtil.getLoginUserVo().getUser();
        return this.getCacheTreeByMerId(admin.getMerId());
    }

    private List<ProCategoryCacheVo> getCacheTreeByMerId(Integer merId) {
        List categoryList;
        if (this.redisUtil.exists(StrUtil.format((CharSequence)"store:product:category:list:{}", (Object[])new Object[]{merId})).booleanValue()) {
            categoryList = (List)this.redisUtil.get(StrUtil.format((CharSequence)"store:product:category:list:{}", (Object[])new Object[]{merId}));
        } else {
            LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
            lqw.eq(MerchantProductCategory::getIsDel, (Object)false);
            lqw.eq(MerchantProductCategory::getIsShow, (Object)true);
            lqw.eq(MerchantProductCategory::getMerId, (Object)merId);
            categoryList = this.dao.selectList((Wrapper)lqw);
            if (CollUtil.isEmpty((Collection)categoryList)) {
                return CollUtil.newArrayList((Object[])new ProCategoryCacheVo[0]);
            }
            this.redisUtil.set(StrUtil.format((CharSequence)"store:product:category:list:{}", (Object[])new Object[]{merId}), (Object)categoryList);
        }
        List voList = categoryList.stream().map(e -> {
            ProCategoryCacheVo cacheVo = new ProCategoryCacheVo();
            BeanUtils.copyProperties((Object)e, (Object)cacheVo);
            return cacheVo;
        }).collect(Collectors.toList());
        ProCategoryCacheTree categoryTree = new ProCategoryCacheTree(voList);
        return categoryTree.buildTree();
    }

    @Override
    public List<ProCategoryCacheVo> findListByMerId(Integer merId) {
        return this.getCacheTreeByMerId(merId);
    }

    @Override
    public List<MerchantProductCategory> getCircleProductCategoryList(List<Integer> merIdList) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(MerchantProductCategory::getIsDel, (Object)false);
        lqw.in(MerchantProductCategory::getMerId, merIdList);
        lqw.orderByDesc(MerchantProductCategory::getSort);
        lqw.orderByAsc(MerchantProductCategory::getId);
        return this.dao.selectList((Wrapper)lqw);
    }

    @Override
    public List<ProCategoryCacheVo> getCircleCacheTree(List<Integer> merIdList) {
        List categoryList;
        if (this.redisUtil.exists(StrUtil.format((CharSequence)"store:product:category:list:{}", (Object[])new Object[]{merIdList})).booleanValue()) {
            categoryList = (List)this.redisUtil.get(StrUtil.format((CharSequence)"store:product:category:list:{}", (Object[])new Object[]{merIdList}));
        } else {
            LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
            lqw.eq(MerchantProductCategory::getIsDel, (Object)false);
            lqw.eq(MerchantProductCategory::getIsShow, (Object)true);
            lqw.in(MerchantProductCategory::getMerId, merIdList);
            categoryList = this.dao.selectList((Wrapper)lqw);
            if (CollUtil.isEmpty((Collection)categoryList)) {
                return CollUtil.newArrayList((Object[])new ProCategoryCacheVo[0]);
            }
            this.redisUtil.set(StrUtil.format((CharSequence)"store:product:category:list:{}", (Object[])new Object[]{merIdList}), (Object)categoryList);
        }
        List voList = categoryList.stream().map(e -> {
            ProCategoryCacheVo cacheVo = new ProCategoryCacheVo();
            BeanUtils.copyProperties((Object)e, (Object)cacheVo);
            return cacheVo;
        }).collect(Collectors.toList());
        ProCategoryCacheTree categoryTree = new ProCategoryCacheTree(voList);
        return categoryTree.buildTree();
    }

    private List<MerchantProductCategory> findAllChildListByPid(Integer pid) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(MerchantProductCategory::getPid, (Object)pid);
        lqw.eq(MerchantProductCategory::getIsDel, (Object)false);
        return this.dao.selectList((Wrapper)lqw);
    }

    private MerchantProductCategory getByIdException(Integer id) {
        MerchantProductCategory category = (MerchantProductCategory)this.getById(id);
        if (ObjectUtil.isNull((Object)category) || category.getIsDel().booleanValue()) {
            throw new CrmebException((IResultEnum)ProductResultCode.PRODUCT_MER_CATEGORY_NOT_EXIST);
        }
        return category;
    }

    private Boolean checkName(String name, Integer merId) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.select(new SFunction[]{MerchantProductCategory::getId});
        lqw.eq(MerchantProductCategory::getName, (Object)name);
        lqw.eq(MerchantProductCategory::getMerId, (Object)merId);
        lqw.eq(MerchantProductCategory::getIsDel, (Object)false);
        lqw.last(" limit 1");
        MerchantProductCategory productCategory = (MerchantProductCategory)this.dao.selectOne((Wrapper)lqw);
        return ObjectUtil.isNotNull((Object)productCategory) ? Boolean.TRUE : Boolean.FALSE;
    }
}

