/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.URLUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.model.admin.SystemAdmin;
import com.zbkj.common.model.express.Express;
import com.zbkj.common.model.express.MerchantExpress;
import com.zbkj.common.model.merchant.MerchantElect;
import com.zbkj.common.page.CommonPage;
import com.zbkj.common.request.MerchantExpressSearchRequest;
import com.zbkj.common.result.CommonResultCode;
import com.zbkj.common.result.IResultEnum;
import com.zbkj.common.result.MerchantResultCode;
import com.zbkj.common.result.SystemConfigResultCode;
import com.zbkj.common.vo.OnePassApplicationInfoVo;
import com.zbkj.service.dao.MerchantExpressDao;
import com.zbkj.service.service.ExpressService;
import com.zbkj.service.service.MerchantElectService;
import com.zbkj.service.service.MerchantExpressService;
import com.zbkj.service.service.OnePassService;
import com.zbkj.service.util.OnePassUtil;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

@Service
public class MerchantExpressServiceImpl
extends ServiceImpl<MerchantExpressDao, MerchantExpress>
implements MerchantExpressService {
    @Resource
    private MerchantExpressDao dao;
    @Autowired
    private ExpressService expressService;
    @Autowired
    private TransactionTemplate transactionTemplate;
    @Autowired
    private MerchantElectService merchantElectService;
    @Autowired
    private OnePassService onePassService;
    @Autowired
    private OnePassUtil onePassUtil;

    @Override
    public Boolean relate(Integer expressId, SystemAdmin admin) {
        Express express = this.expressService.getInfo(expressId);
        if (!express.getIsShow().booleanValue()) {
            throw new CrmebException((IResultEnum)SystemConfigResultCode.EXPRESS_NOT_EXIST);
        }
        if (this.validateMerAndExpress(admin.getMerId(), expressId).booleanValue()) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u5df2\u5173\u8054\u6b64\u7269\u6d41\u516c\u53f8");
        }
        MerchantExpress merchantExpress = new MerchantExpress();
        merchantExpress.setMerId(admin.getMerId());
        merchantExpress.setExpressId(expressId);
        merchantExpress.setCode(express.getCode());
        merchantExpress.setName(express.getName());
        merchantExpress.setPartnerId(express.getPartnerId());
        merchantExpress.setPartnerKey(express.getPartnerKey());
        merchantExpress.setNet(express.getNet());
        return this.save(merchantExpress);
    }

    private Boolean validateMerAndExpress(Integer merId, Integer expressId) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(MerchantExpress::getMerId, (Object)merId);
        lqw.eq(MerchantExpress::getExpressId, (Object)expressId);
        lqw.eq(MerchantExpress::getIsDelete, (Object)0);
        lqw.last(" limit 1");
        MerchantExpress merchantExpress = (MerchantExpress)this.dao.selectOne((Wrapper)lqw);
        return ObjectUtil.isNotNull((Object)merchantExpress);
    }

    @Override
    public PageInfo<MerchantExpress> searchPage(MerchantExpressSearchRequest request, SystemAdmin admin) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.select(new SFunction[]{MerchantExpress::getId, MerchantExpress::getCode, MerchantExpress::getName, MerchantExpress::getIsDefault, MerchantExpress::getIsOpen, MerchantExpress::getPartnerId, MerchantExpress::getPartnerKey, MerchantExpress::getNet, MerchantExpress::getAccount, MerchantExpress::getPassword, MerchantExpress::getNetName});
        lqw.eq(MerchantExpress::getMerId, (Object)admin.getMerId());
        lqw.eq(MerchantExpress::getIsDelete, (Object)0);
        if (ObjectUtil.isNotNull((Object)request.getOpenStatus())) {
            lqw.eq(MerchantExpress::getIsOpen, (Object)request.getOpenStatus());
        }
        if (StrUtil.isNotBlank((CharSequence)request.getKeywords())) {
            String keywords = URLUtil.decode((String)request.getKeywords());
            lqw.and(i -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)i.like(MerchantExpress::getName, (Object)keywords)).or()).like(MerchantExpress::getCode, (Object)keywords);
            });
        }
        lqw.orderByDesc((Object[])new SFunction[]{MerchantExpress::getIsDefault, MerchantExpress::getExpressId});
        Page page = PageHelper.startPage((int)request.getPage(), (int)request.getLimit());
        List merchantExpressList = this.dao.selectList((Wrapper)lqw);
        return CommonPage.copyPageInfo((Page)page, (List)merchantExpressList);
    }

    @Override
    public JSONObject template(String com, SystemAdmin admin) {
        MerchantElect merchantElect = this.merchantElectService.getMerchantElect(admin);
        if (ObjectUtil.isNull((Object)merchantElect) || merchantElect.getId() <= 0) {
            throw new CrmebException("\u8bf7\u5148\u914d\u7f6e\u7535\u5b50\u9762\u5355\u6253\u5370\u914d\u7f6e");
        }
        if (merchantElect.getOp().equals(1) && ObjectUtil.isNull((Object)merchantElect.getCloudPrintNo())) {
            throw new CrmebException("\u4e91\u6253\u5370\u673a\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Integer isShipment = merchantElect.getCloudPrintNo().isEmpty() ? 1 : 0;
        OnePassApplicationInfoVo infoVo = this.onePassService.getApplicationInfoException();
        String token = this.onePassUtil.getToken(infoVo);
        HashMap<String, String> header = this.onePassUtil.getCommonHeader(token);
        LinkedMultiValueMap param = new LinkedMultiValueMap();
        param.add((Object)"com", (Object)com);
        param.add((Object)"is_shipment", (Object)isShipment);
        return this.onePassUtil.getFrom("https://sms.crmeb.net/api/v2/expr_dump/temp", (MultiValueMap<String, Object>)param, header);
    }

    @Override
    public Boolean openSwitch(Integer id, SystemAdmin admin) {
        MerchantExpress merchantExpress = this.getByIdException(id);
        if (!admin.getMerId().equals(merchantExpress.getMerId())) {
            throw new CrmebException((IResultEnum)MerchantResultCode.MERCHANT_EXPRESS_NOT_EXIST);
        }
        merchantExpress.setIsOpen(Boolean.valueOf(merchantExpress.getIsOpen() == false));
        return this.updateById(merchantExpress);
    }

    @Override
    public Boolean defaultSwitch(Integer id, SystemAdmin admin) {
        MerchantExpress merchantExpress = this.getByIdException(id);
        if (!admin.getMerId().equals(merchantExpress.getMerId())) {
            throw new CrmebException((IResultEnum)MerchantResultCode.MERCHANT_EXPRESS_NOT_EXIST);
        }
        if (merchantExpress.getIsDefault().booleanValue()) {
            merchantExpress.setIsDefault(Boolean.valueOf(false));
            return this.updateById(merchantExpress);
        }
        merchantExpress.setIsDefault(Boolean.valueOf(true));
        return (Boolean)this.transactionTemplate.execute(e -> {
            this.cancelDefaultByMerId(merchantExpress.getMerId());
            this.updateById(merchantExpress);
            return Boolean.TRUE;
        });
    }

    @Override
    public Boolean delete(Integer id, SystemAdmin admin) {
        MerchantExpress merchantExpress = this.getByIdException(id);
        if (!admin.getMerId().equals(merchantExpress.getMerId())) {
            throw new CrmebException((IResultEnum)MerchantResultCode.MERCHANT_EXPRESS_NOT_EXIST);
        }
        merchantExpress.setIsDelete(Boolean.valueOf(true));
        return this.updateById(merchantExpress);
    }

    private void cancelDefaultByMerId(Integer merId) {
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
        wrapper.set(MerchantExpress::getIsDefault, (Object)0);
        wrapper.eq(MerchantExpress::getIsDelete, (Object)0);
        wrapper.eq(MerchantExpress::getMerId, (Object)merId);
        this.update((Wrapper)wrapper);
    }

    private MerchantExpress getByIdException(Integer id) {
        MerchantExpress merchantExpress = (MerchantExpress)this.getById(id);
        if (ObjectUtil.isNull((Object)merchantExpress)) {
            throw new CrmebException((IResultEnum)MerchantResultCode.MERCHANT_EXPRESS_NOT_EXIST);
        }
        return merchantExpress;
    }

    @Override
    public Boolean deleteByExpressId(Integer expressId) {
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
        wrapper.set(MerchantExpress::getIsDelete, (Object)1);
        wrapper.eq(MerchantExpress::getExpressId, (Object)expressId);
        wrapper.eq(MerchantExpress::getIsDelete, (Object)0);
        return this.update((Wrapper)wrapper);
    }

    @Override
    public MerchantExpress getByCode(String code, Integer merId) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(MerchantExpress::getCode, (Object)code);
        lqw.eq(MerchantExpress::getMerId, (Object)merId);
        lqw.eq(MerchantExpress::getIsDelete, (Object)0);
        lqw.last(" limit 1");
        return (MerchantExpress)this.dao.selectOne((Wrapper)lqw);
    }
}

